/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.easyscript.example;

import com.scriptel.easyscript.CardSwipe;
import com.scriptel.easyscript.CardSwipeInvalidException;
import com.scriptel.easyscript.EasyScript;
import com.scriptel.easyscript.Signature;
import com.scriptel.easyscript.SignatureInvalidException;
import com.scriptel.easyscript.example.ExampleForm;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import javax.swing.JTextArea;

public class LegacyExample {
    private ExampleForm form;
    private StringBuilder buffer = new StringBuilder();
    private EasyScript eScript;
    private boolean signature;
    private boolean capturing = false;

    public LegacyExample() {
        this.form = new ExampleForm();
        this.form.setVisible(true);
        this.eScript = new EasyScript();
        KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        mgr.addKeyEventDispatcher(new ScriptelKeyboardDispatcher());
    }

    public static void main(String[] args) {
        LegacyExample app = new LegacyExample();
    }

    private void handleSignature(Signature s) {
        Canvas canvas = this.form.getCanvas();
        JTextArea textArea = this.form.getTextArea();
        BufferedImage img = this.eScript.renderSignature(s, Color.black, Color.white, 2, 2.0f);
        canvas.getGraphics().drawImage(img, 0, 0, null);
        textArea.setText(s.toString());
        textArea.setSelectionStart(0);
        textArea.setSelectionEnd(0);
    }

    private void handleCardSwipe(CardSwipe s) {
        Canvas canvas = this.form.getCanvas();
        JTextArea textArea = this.form.getTextArea();
        Graphics2D ctx = (Graphics2D)canvas.getGraphics();
        ctx.setColor(Color.white);
        ctx.fillRect(0, 0, 480, 128);
        textArea.setText(s.toString());
        textArea.setSelectionStart(0);
        textArea.setSelectionEnd(0);
    }

    private void handleException(Exception s) {
        Canvas canvas = this.form.getCanvas();
        JTextArea textArea = this.form.getTextArea();
        Graphics2D ctx = (Graphics2D)canvas.getGraphics();
        ctx.setColor(Color.white);
        ctx.fillRect(0, 0, 480, 128);
        textArea.setText(s.toString() + "\n" + this.buffer);
        textArea.setSelectionStart(0);
        textArea.setSelectionEnd(0);
    }

    private class ScriptelKeyboardDispatcher
    implements KeyEventDispatcher {
        private ScriptelKeyboardDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent ke) {
            if (ke.getID() == 400) {
                if (!LegacyExample.this.capturing && ke.getKeyChar() == LegacyExample.this.eScript.getSignatureProtocol().getStartStream()) {
                    LegacyExample.this.capturing = true;
                    LegacyExample.this.signature = true;
                } else if (!LegacyExample.this.capturing && ke.getKeyChar() == LegacyExample.this.eScript.getCardProtocol().getStartStream()) {
                    LegacyExample.this.capturing = true;
                    LegacyExample.this.signature = false;
                }
                if (LegacyExample.this.capturing) {
                    LegacyExample.this.buffer.append(ke.getKeyChar());
                    ke.consume();
                }
                if (LegacyExample.this.capturing && LegacyExample.this.signature && ke.getKeyChar() == LegacyExample.this.eScript.getSignatureProtocol().getEndStream()) {
                    LegacyExample.this.capturing = false;
                    try {
                        Signature s = LegacyExample.this.eScript.parseSignature(LegacyExample.this.buffer.toString());
                        LegacyExample.this.handleSignature(s);
                    }
                    catch (SignatureInvalidException e) {
                        LegacyExample.this.handleException(e);
                    }
                    LegacyExample.this.buffer.delete(0, LegacyExample.this.buffer.length());
                } else if (LegacyExample.this.capturing && !LegacyExample.this.signature && ke.getKeyChar() == LegacyExample.this.eScript.getCardProtocol().getEndStream()) {
                    LegacyExample.this.capturing = false;
                    try {
                        CardSwipe s = LegacyExample.this.eScript.parseCardSwipe(LegacyExample.this.buffer.toString());
                        LegacyExample.this.handleCardSwipe(s);
                    }
                    catch (CardSwipeInvalidException e) {
                        LegacyExample.this.handleException(e);
                    }
                    LegacyExample.this.buffer.delete(0, LegacyExample.this.buffer.length());
                }
            }
            return false;
        }
    }
}

