/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.easyscript;

import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FinancialCardTrackOne {
    private String accountNumber;
    private String firstName;
    private String lastName;
    private Date expiration;
    private String serviceCode;
    private String discretionaryData;

    public static FinancialCardTrackOne parse(String trackData) {
        Pattern p = Pattern.compile(".*%[A-Z]{1}(\\d{1,19})\\^([^\\^]{1,30})\\^(\\d{2})(\\d{2})([0-9]{3})([A-Za-z 0-9]*)\\?.*");
        Matcher m = p.matcher(trackData);
        if (m.matches()) {
            FinancialCardTrackOne track = new FinancialCardTrackOne();
            track.setAccountNumber(m.group(1));
            track.setServiceCode(m.group(5));
            track.setDiscretionaryData(m.group(6));
            String name = m.group(2);
            int idx = name.indexOf(47);
            if (idx >= 0) {
                track.setLastName(name.substring(0, idx).trim());
                track.setFirstName(name.substring(idx + 1).trim());
            } else {
                track.setLastName(name.trim());
                track.setFirstName("");
            }
            Calendar c = Calendar.getInstance();
            c.set(1, Integer.parseInt(m.group(3)) + 2000);
            c.set(2, Integer.parseInt(m.group(4)));
            c.set(5, 1);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            c.add(14, -1);
            track.setExpiration(c.getTime());
            return track;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String ln = System.getProperty("line.separator");
        sb.append("Financial Card - Track One:").append(ln);
        sb.append("    Account Number: ").append(this.accountNumber).append(ln);
        sb.append("        First Name: ").append(this.firstName).append(ln);
        sb.append("         Last Name: ").append(this.lastName).append(ln);
        sb.append("        Expiration: ").append(this.expiration).append(ln);
        sb.append("      Service Code: ").append(this.serviceCode).append(ln);
        sb.append("Discretionary Data: ").append(this.discretionaryData).append(ln);
        return sb.toString();
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    private void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getFirstName() {
        return this.firstName;
    }

    private void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    private void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    private void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    private void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    public String getDiscretionaryData() {
        return this.discretionaryData;
    }

    private void setDiscretionaryData(String discretionaryData) {
        this.discretionaryData = discretionaryData;
    }
}

