package com.company;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.Line2D;
import java.util.LinkedList;
import java.util.List;

public class SignaturePanel extends JPanel {

    private final List<List<Coordinate>> strokes = new LinkedList<>();

    private double lastX;
    private double lastY;

    public SignaturePanel() {
        setPreferredSize(new Dimension(240,64));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }
    public void addCoordinate(double x, double y) {
        if(strokes.isEmpty()) {
            addStroke();
        }
        List<Coordinate> currentStroke = ((LinkedList<List<Coordinate>>)strokes).getLast();
        if(!currentStroke.isEmpty()) {
            Graphics2D g = (Graphics2D)getGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(Color.BLACK);
            int width = getWidth();
            int height = getHeight();
            g.draw(new Line2D.Double(lastX * width, lastY * height, x * width, y * height));
        }

        currentStroke.add(new Coordinate(x, y));
        lastX = x;
        lastY = y;
    }

    public void addStroke() {
        strokes.add(new LinkedList<>());
    }

    public void clear() {
        strokes.clear();
        repaint();
    }

    private class Coordinate {
        double x;
        double y;

        public Coordinate(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double getX() {
            return x;
        }

        public double getY() {
            return y;
        }
    }
}
