package com.company;

import com.scriptel.proscript.*;
import com.scriptel.proscript.input.*;
import javax.swing.*;
import java.io.IOException;

public class Main {

    private static SignaturePanel signature;

    public static void main(String[] args) {
        JFrame frame = new JFrame("frame");
        signature = new SignaturePanel();
        frame.add(signature);
        frame.setSize(400,200);
        frame.setVisible(true);

        Device d = null;
        try {
            d = DeviceManager.getAttachedDevices()[0];
            d.open();
            CoordinateRange range = d.getCoordinateRange();
            d.registerInputListener(new Main().new ProScriptEventListener(range));

            while(d.isOpen()) {
                try {
                    d.read();
                } catch (IOException ex) {
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class ProScriptEventListener implements InputListener {
        private final CoordinateRange range;

        public ProScriptEventListener(CoordinateRange range) {
            this.range = range;
        }

        @Override
        public void recieveCoordinateEvent(Coordinate c) {
            System.out.println("Receive coordinate: " + c.getX() + " " + c.getY() );
            double x = (c.getX() - range.getXMin()) / (double) (range.getXMax() - range.getXMin());
            double y = (c.getY() - range.getYMin()) / (double) (range.getYMax() - range.getYMin());
            signature.addCoordinate(x, y);

            if (!c.isPenDown()) {
                signature.addStroke();
            }
        }

        @Override
        public void recieveDebugCoordinateEvent(DebugCoordinate c) {
        }

        @Override
        public void recieveMagneticStripEvent(MagneticCardSwipe c) {
        }

        @Override
        public void recieveADCScanValues(ADCScanValues c) {
        }

        @Override
        public void recieveADCChannelValues(ADCChannelValues c) {
        }

        @Override
        public void receiveButtonEvent(ButtonEvent c) {
            if (c instanceof ButtonPress) {
                signature.clear();
                    System.out.println("Button pressed: " + c.getRegion());
            }
        }
    }
}
