/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript.nativelib;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;

public class NativeLoader {
    private static final Logger LOGGER = Logger.getLogger(NativeLoader.class.getName());
    private static final String OS_NAME;
    private static final String DYNLIB_EXT;
    private static final String ARCHITECTURE;
    private static final boolean SKIP_NATIVE;
    private static final String PROSCRIPT_NAME = "libscriptel-proscript";
    private static final String JNIBINDINGS_NAME = "libscriptel-proscript-jnibindings";

    public static void load() throws IOException {
        File jniFile;
        int count;
        byte[] buffer;
        FileOutputStream out;
        InputStream in;
        String libName = "libscriptel-proscript-" + OS_NAME + "-" + ARCHITECTURE + DYNLIB_EXT;
        String jniName = "libscriptel-proscript-jnibindings-" + OS_NAME + "-" + ARCHITECTURE + DYNLIB_EXT;
        String override = System.getProperty("library.proscript.directory");
        File tempDir = override != null ? new File(override) : NativeLoader.createTemporaryDirectory();
        tempDir.deleteOnExit();
        if (!SKIP_NATIVE) {
            File libFile = new File(tempDir + System.getProperty("file.separator") + libName);
            if (!libFile.exists()) {
                in = NativeLoader.class.getResourceAsStream(libName);
                try {
                    out = new FileOutputStream(libFile);
                    try {
                        if (in == null) {
                            throw new IOException("Unable to find embedded library file: " + libName);
                        }
                        buffer = new byte[2048];
                        while ((count = in.read(buffer)) >= 0) {
                            ((OutputStream)out).write(buffer, 0, count);
                        }
                        libFile.deleteOnExit();
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            System.load(libFile.getAbsolutePath());
        }
        if (!(jniFile = new File(tempDir + System.getProperty("file.separator") + jniName)).exists()) {
            in = NativeLoader.class.getResourceAsStream(jniName);
            try {
                out = new FileOutputStream(jniFile);
                try {
                    if (in == null) {
                        throw new IOException("Unable to find embedded library file: " + libName);
                    }
                    buffer = new byte[2048];
                    while ((count = in.read(buffer)) >= 0) {
                        ((OutputStream)out).write(buffer, 0, count);
                    }
                    jniFile.deleteOnExit();
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        System.load(jniFile.getAbsolutePath());
    }

    private static File createTemporaryDirectory() throws IOException {
        File tmp = File.createTempFile("proscriptjni", Long.toString(System.currentTimeMillis()));
        if (!tmp.delete()) {
            throw new IOException("Couldn't create temporary file at: " + tmp.getAbsolutePath());
        }
        if (!tmp.mkdir()) {
            throw new IOException("Couldn't create temporary directory at: " + tmp.getAbsolutePath());
        }
        return tmp;
    }

    static {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            OS_NAME = "windows";
            DYNLIB_EXT = ".dll";
            SKIP_NATIVE = false;
        } else if (os.contains("mac")) {
            OS_NAME = "mac";
            DYNLIB_EXT = ".dylib";
            SKIP_NATIVE = true;
        } else if (os.contains("nux")) {
            OS_NAME = "linux";
            DYNLIB_EXT = ".so";
            SKIP_NATIVE = true;
        } else {
            OS_NAME = "unknown";
            DYNLIB_EXT = ".so";
            SKIP_NATIVE = true;
        }
        ARCHITECTURE = System.getProperty("os.arch").toLowerCase().contains("arm") ? "armhf" : (System.getProperty("os.arch").contains("64") ? "x64" : "x32");
    }
}

