/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript.input;

import com.scriptel.proscript.cardswipe.CardParser;
import com.scriptel.proscript.cardswipe.FinancialCard;
import com.scriptel.proscript.cardswipe.IdentificationCard;

public final class MagneticCardSwipe {
    public static final int CARD_FORMAT_FINANCIAL = 1;
    public static final int CARD_FORMAT_IDENTITY = 2;
    public static final int CARD_FORMAT_UNKNOWN = 255;
    public static final int TRACK_STATUS_VALID = 0;
    public static final int TRACK_STATUS_PARITY_ERROR = 1;
    public static final int TRACK_STATUS_UNKNOWN_FORMAT = 16;
    public static final int TRACK_STATUS_CORRUPT = 17;
    private final int cardFormat;
    private final int trackOneStatus;
    private final int trackTwoStatus;
    private final int trackThreeStatus;
    private final String trackOne;
    private final String trackTwo;
    private final String trackThree;

    private MagneticCardSwipe(int cardFormat, int trackOneStatus, int trackTwoStatus, int trackThreeStatus, String trackOne, String trackTwo, String trackThree) {
        this.cardFormat = cardFormat;
        this.trackOneStatus = trackOneStatus;
        this.trackTwoStatus = trackTwoStatus;
        this.trackThreeStatus = trackThreeStatus;
        this.trackOne = trackOne;
        this.trackTwo = trackTwo;
        this.trackThree = trackThree;
    }

    public FinancialCard parseAsFinancialCard() {
        return CardParser.parseFinancialCard(this.trackOneStatus == 0, this.trackOne, this.trackTwoStatus == 0, this.trackTwo);
    }

    public IdentificationCard parseAsIdentificationCard() {
        return CardParser.parseIdentificationCard(this.trackOneStatus == 0, this.trackOne, this.trackTwoStatus == 0, this.trackTwo, this.trackThreeStatus == 0, this.trackThree);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Magnetic Card Swipe: \n");
        sb.append("            Card Type: ").append(this.getCardFormatString()).append("\n");
        sb.append("     Track One Status: ").append(this.getTrackOneStatusString()).append("\n");
        sb.append("     Track Two Status: ").append(this.getTrackTwoStatusString()).append("\n");
        sb.append("   Track Three Status: ").append(this.getTrackThreeStatusString()).append("\n");
        sb.append("            Track One: ").append(this.trackOne).append("\n");
        sb.append("            Track Two: ").append(this.trackTwo).append("\n");
        sb.append("          Track Three: ").append(this.trackThree).append("\n");
        return sb.toString();
    }

    public String getCardFormatString() {
        if (this.cardFormat == 1) {
            return "Financial";
        }
        if (this.cardFormat == 2) {
            return "Identity";
        }
        return "Unknown";
    }

    public String getTrackOneStatusString() {
        return MagneticCardSwipe.getTrackStatusString(this.trackOneStatus);
    }

    public String getTrackTwoStatusString() {
        return MagneticCardSwipe.getTrackStatusString(this.trackTwoStatus);
    }

    public String getTrackThreeStatusString() {
        return MagneticCardSwipe.getTrackStatusString(this.trackThreeStatus);
    }

    public static String getTrackStatusString(int status) {
        if (status == 0) {
            return "Valid";
        }
        if (status == 1) {
            return "Parity Error";
        }
        if (status == 16) {
            return "Unknown Format";
        }
        if (status == 17) {
            return "Corrupt";
        }
        return "Unknown";
    }

    public int getCardFormat() {
        return this.cardFormat;
    }

    public int getTrackOneStatus() {
        return this.trackOneStatus;
    }

    public int getTrackTwoStatus() {
        return this.trackTwoStatus;
    }

    public int getTrackThreeStatus() {
        return this.trackThreeStatus;
    }

    public String getTrackOne() {
        return this.trackOne;
    }

    public String getTrackTwo() {
        return this.trackTwo;
    }

    public String getTrackThree() {
        return this.trackThree;
    }
}

