/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript.firmware;

import com.scriptel.proscript.firmware.SRECParseException;

public class SRECRecord {
    public static final byte TYPE_BLOCK_HEADER = 0;
    public static final byte TYPE_DATA_SEQ_16_BIT = 1;
    public static final byte TYPE_DATA_SEQ_24_BIT = 2;
    public static final byte TYPE_DATA_SEQ_32_BIT = 3;
    public static final byte TYPE_RECORD_COUNT = 5;
    public static final byte TYPE_END_OF_BLOCK_32_BIT = 7;
    public static final byte TYPE_END_OF_BLOCK_24_BIT = 8;
    public static final byte TYPE_END_OF_BLOCK_16_BIT = 9;
    private byte type;
    private byte[] data;
    private long address;

    public SRECRecord(String line) throws SRECParseException {
        int calc;
        if (line.length() < 5) {
            throw new SRECParseException("Line presented is not a valid SREC record: line too short " + line.length());
        }
        if (line.charAt(0) != 'S') {
            throw new SRECParseException("Line presented is not a valid SREC record: " + line);
        }
        if (line.charAt(1) < '0' && line.charAt(1) > '9') {
            throw new SRECParseException("Record type not recognized: " + line.charAt(1) + " (" + line.charAt(1) * '\u0001' + ")");
        }
        if (line.length() % 2 == 1) {
            throw new SRECParseException("Invalid line length: " + line.length());
        }
        int lineLen = this.convertByte(line.charAt(2), line.charAt(3)) & 0xFF;
        if (line.length() != lineLen * 2 + 4) {
            throw new SRECParseException("Was expecting a string of length " + (lineLen * 2 + 4) + " but got a string of length " + line.length());
        }
        this.type = (byte)(line.charAt(1) - 48 & 0xFF);
        int addrLen = this.getAddressLength();
        int dataLen = lineLen - addrLen - 1;
        int addrStart = 4;
        int dataStart = addrStart + addrLen * 2;
        int checksumStart = line.length() - 2;
        this.data = this.convertBytes(line, dataStart, dataLen);
        int checksum = this.convertBytes(line, checksumStart, 1)[0] & 0xFF;
        if (checksum != (calc = this.calculateChecksum(line) & 0xFF)) {
            throw new SRECParseException("Incorrect checksum, was expecting " + calc + " and got " + checksum);
        }
        this.address = this.convertBytes(this.convertBytes(line, addrStart, addrLen));
    }

    private int getAddressLength() {
        switch (this.getType()) {
            case 0: 
            case 1: 
            case 5: 
            case 9: {
                return 2;
            }
            case 2: 
            case 8: {
                return 3;
            }
            case 3: 
            case 7: {
                return 4;
            }
        }
        return -1;
    }

    private long convertBytes(byte[] bytes) {
        long num = 0L;
        for (int x = 0; x < bytes.length; ++x) {
            int shift = (bytes.length - 1 - x) * 8;
            num |= (long)((bytes[x] & 0xFF) << shift);
        }
        return num;
    }

    private byte[] convertBytes(String source, int start, int len) throws SRECParseException {
        if (len <= 0) {
            return new byte[0];
        }
        byte[] retr = new byte[len];
        for (int x = 0; x < len; ++x) {
            int idx = start + x * 2;
            retr[x] = this.convertByte(source.charAt(idx), source.charAt(idx + 1));
        }
        return retr;
    }

    private byte convertByte(char c1, char c2) throws SRECParseException {
        if (c1 < '0' && c1 > '9' && c1 < 'A' && c1 > 'F') {
            throw new SRECParseException("Character at position 1 isn't in the valid range 0-9 or A-F: '" + c1 + "' (" + c1 * '\u0001' + ")");
        }
        if (c2 < '0' && c2 > '9' && c2 < 'A' && c2 > 'F') {
            throw new SRECParseException("Character at position 1 isn't in the valid range 0-9 or A-F: '" + c2 + "' (" + c1 * '\u0001' + ")");
        }
        byte retr = 0;
        retr = (byte)(retr | (c1 <= '9' ? c1 - 48 : c1 - 55) << 4);
        retr = (byte)(retr | (c2 <= '9' ? c2 - 48 : c2 - 55));
        return retr;
    }

    private String getTypeName() {
        switch (this.getType()) {
            case 0: {
                return "TYPE_BLOCK_HEADER";
            }
            case 1: {
                return "TYPE_DATA_SEQ_16_BIT";
            }
            case 2: {
                return "TYPE_DATA_SEQ_24_BIT";
            }
            case 3: {
                return "TYPE_DATA_SEQ_32_BIT";
            }
            case 5: {
                return "TYPE_RECORD_COUNT";
            }
            case 7: {
                return "TYPE_END_OF_BLOCK_32_BIT";
            }
            case 8: {
                return "TYPE_END_OF_BLOCK_24_BIT";
            }
            case 9: {
                return "TYPE_END_OF_BLOCK_16_BIT";
            }
        }
        return "Unknown";
    }

    private byte calculateChecksum(String line) throws SRECParseException {
        byte[] bytes = this.convertBytes(line, 2, line.length() / 2 - 2);
        byte retr = 0;
        for (int x = 0; x < bytes.length; ++x) {
            retr = (byte)(retr + bytes[x]);
        }
        retr = (byte)(255 - retr);
        return retr;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SREC Record:\n");
        sb.append("Type: ").append(this.getTypeName()).append('\n');
        sb.append("Address: ").append(this.getAddress()).append('\n');
        sb.append("Data (len: ").append(this.getData().length).append("): ");
        for (int x = 0; x < this.getData().length; ++x) {
            sb.append(Integer.toHexString(this.getData()[x] & 0xFF));
            if (x + 1 >= this.getData().length) continue;
            sb.append(",");
        }
        sb.append('\n');
        return sb.toString();
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public long getAddress() {
        return this.address;
    }

    public void setAddress(long address) {
        this.address = address;
    }
}

