/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript.firmware;

import com.scriptel.proscript.FirmwarePage;
import com.scriptel.proscript.firmware.FirmwarePackage;
import com.scriptel.proscript.firmware.FirmwareRestriction;
import com.scriptel.proscript.firmware.SRECRecord;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class SRECFirmwarePackage
implements FirmwarePackage {
    private final List<SRECRecord> list = new ArrayList<SRECRecord>();
    private final List<FirmwarePage> pages = new ArrayList<FirmwarePage>();
    private int pos = 0;

    @Override
    public void readStream(InputStream in) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                SRECRecord r = new SRECRecord(line);
                this.list.add(r);
            }
        }
        this.convert();
    }

    @Override
    public FirmwarePage nextPage() {
        if (this.pos < this.pages.size()) {
            FirmwarePage p = this.pages.get(this.pos++);
            p.recalculateChecksum();
            return p;
        }
        return null;
    }

    public void convert() {
        for (SRECRecord r : this.list) {
            boolean processRecord;
            switch (r.getType()) {
                case 1: 
                case 2: 
                case 3: {
                    processRecord = true;
                    break;
                }
                default: {
                    processRecord = false;
                }
            }
            if (!processRecord) continue;
            this.injectPageData(r.getAddress(), r.getData());
        }
    }

    private void injectPageData(long startAddr, byte[] data) {
        for (long x = startAddr; x < startAddr + (long)data.length; ++x) {
            int pageNum = (int)(x / 128L);
            FirmwarePage p = this.getPage(pageNum);
            int pageOffset = (int)(x - (long)(pageNum * 128));
            int recordOffset = (int)(x - startAddr);
            p.getData()[pageOffset] = data[recordOffset];
        }
    }

    private FirmwarePage getPage(long pageNum) {
        for (FirmwarePage page : this.pages) {
            if ((long)(page.getAddress() / 128) != pageNum) continue;
            return page;
        }
        byte[] bytes = new byte[128];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = -1;
        }
        FirmwarePage p = new FirmwarePage((int)(pageNum * 128L), bytes);
        this.pages.add(p);
        return p;
    }

    @Override
    public int getPageCount() {
        return this.pages.size();
    }

    @Override
    public List<FirmwareRestriction> getRestrictions() {
        return new ArrayList<FirmwareRestriction>();
    }
}

