/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript.firmware;

import com.google.gson.Gson;
import com.scriptel.proscript.FirmwarePage;
import com.scriptel.proscript.firmware.DeviceProductRestriction;
import com.scriptel.proscript.firmware.FWFirmwareDevice;
import com.scriptel.proscript.firmware.FWFirmwarePackageFormat;
import com.scriptel.proscript.firmware.FirmwarePackage;
import com.scriptel.proscript.firmware.FirmwareRestriction;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class FWFirmwarePackage
implements FirmwarePackage {
    private static final Logger LOGGER = Logger.getLogger(FWFirmwarePackage.class.getName());
    private final List<FirmwarePage> pages = new ArrayList<FirmwarePage>();
    private int pos = 0;
    private List<FWFirmwareDevice> supportedDevices;

    @Override
    public void readStream(InputStream in) throws IOException {
        try (BufferedInputStream io = new BufferedInputStream(in);){
            ((InputStream)io).mark(3);
            boolean compressed = ((InputStream)io).read() == 31 && ((InputStream)io).read() == 139;
            ((InputStream)io).reset();
            FilterInputStream wrapper = compressed ? new GZIPInputStream(io) : io;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)wrapper, StandardCharsets.UTF_8));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append('\n');
                }
                int sigStart = sb.indexOf("-----BEGIN SIGNATURE-----");
                int sigEnd = sb.indexOf("-----END SIGNATURE-----");
                if (sigStart < 0 || sigEnd < 0) {
                    throw new IOException("Missing firmware signature.");
                }
                String json = sb.substring(0, sigStart);
                String signature = sb.substring(sigStart + 26, sigEnd - 1).replace("\n", "");
                try {
                    Certificate c = FWFirmwarePackage.loadPublicKey();
                    byte[] sigBytes = Base64.getDecoder().decode(signature);
                    Signature sig = Signature.getInstance("MD5withRSA");
                    sig.initVerify(c);
                    sig.update(json.getBytes(StandardCharsets.UTF_8));
                    if (!sig.verify(sigBytes)) {
                        throw new IOException("Signature did not verify on firmware package. Corruption or modification has occurred.");
                    }
                }
                catch (GeneralSecurityException e) {
                    throw new IOException("Problem loading public key for firmware validation.", e);
                }
                Gson g = new Gson();
                FWFirmwarePackageFormat pkg = (FWFirmwarePackageFormat)g.fromJson(json, FWFirmwarePackageFormat.class);
                this.supportedDevices = pkg.getDevices();
                for (byte[] page : pkg.getFirmware()) {
                    if (page.length != 134 || page[0] != 25) continue;
                    int address = page[1] & 0xFF;
                    address |= (page[2] & 0xFF) << 8;
                    address |= (page[3] & 0xFF) << 16;
                    byte[] data = new byte[128];
                    System.arraycopy(page, 5, data, 0, 128);
                    FirmwarePage p = new FirmwarePage(address |= (page[4] & 0xFF) << 24, data);
                    if (p.getChecksum() != page[page.length - 1]) {
                        throw new IOException("Record checksum failure, firmware file is corrupt or invalid " + p.getChecksum() + " != " + page[page.length - 1]);
                    }
                    this.pages.add(p);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Certificate loadPublicKey() throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        InputStream in = null;
        try {
            in = FWFirmwarePackage.class.getResourceAsStream("firmwarekey.pem");
            Certificate certificate = factory.generateCertificate(in);
            return certificate;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, "Unable to close input stream.", e);
                }
            }
        }
    }

    @Override
    public FirmwarePage nextPage() {
        if (this.pos < this.pages.size()) {
            return this.pages.get(this.pos++);
        }
        return null;
    }

    @Override
    public int getPageCount() {
        return this.pages.size();
    }

    @Override
    public List<FirmwareRestriction> getRestrictions() {
        ArrayList<FirmwareRestriction> restrictions = new ArrayList<FirmwareRestriction>();
        restrictions.add(new DeviceProductRestriction(this.supportedDevices));
        return restrictions;
    }
}

