/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript.firmware;

import com.scriptel.proscript.Device;
import com.scriptel.proscript.firmware.FWFirmwareDevice;
import com.scriptel.proscript.firmware.FirmwareRestriction;
import java.util.List;

public class DeviceProductRestriction
implements FirmwareRestriction {
    private final List<FWFirmwareDevice> supported;

    public DeviceProductRestriction(List<FWFirmwareDevice> supported) {
        this.supported = supported;
    }

    @Override
    public boolean meetsRestriction(Device d) {
        if (this.supported == null) {
            return false;
        }
        StringBuilder devVendorId = new StringBuilder(Integer.toHexString(d.getVendorId()));
        StringBuilder devProductId = new StringBuilder(Integer.toHexString(d.getProductId()));
        while (devVendorId.length() < 4) {
            devVendorId.insert(0, '0');
        }
        while (devProductId.length() < 4) {
            devProductId.insert(0, '0');
        }
        for (FWFirmwareDevice s : this.supported) {
            if (!DeviceProductRestriction.matches(s.getVendorId(), s.getProductId(), devVendorId.toString(), devProductId.toString())) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(String vId, String pId, String devVendorId, String devProductId) {
        char c2;
        char c1;
        int i;
        if (vId.length() != 4 || pId.length() != 4) {
            return false;
        }
        for (i = 0; i < vId.length(); ++i) {
            c1 = vId.charAt(i);
            if (c1 == (c2 = devVendorId.charAt(i)) || c1 == '?') continue;
            return false;
        }
        for (i = 0; i < pId.length(); ++i) {
            c1 = pId.charAt(i);
            if (c1 == (c2 = devProductId.charAt(i)) || c1 == '?') continue;
            return false;
        }
        return true;
    }
}

