/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript.cardswipe;

import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IdentificationCardTrackTwo {
    private String issuerNumber;
    private String idNumber;
    private Date expiration;
    private Date birthDate;

    public static IdentificationCardTrackTwo parse(String trackData) {
        Pattern p = Pattern.compile(".*;(6[0-9]{5})([0-9]{1,13})=([0-9]{4})([0-9]{8})([0-9]{0,5})=?\\?.*");
        Matcher m = p.matcher(trackData);
        if (m.matches()) {
            IdentificationCardTrackTwo track = new IdentificationCardTrackTwo();
            track.setIssuerNumber(m.group(1));
            track.setIdNumber(m.group(2));
            int expYear = 2000 + Integer.parseInt(m.group(3).substring(0, 2));
            int expMonth = Integer.parseInt(m.group(3).substring(2));
            Calendar c = Calendar.getInstance();
            c.set(1, expYear);
            c.set(2, expMonth);
            c.set(5, 1);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            c.add(14, -1);
            track.setExpiration(c.getTime());
            int birthYear = Integer.parseInt(m.group(4).substring(0, 4));
            int birthMonth = Integer.parseInt(m.group(4).substring(4, 6)) - 1;
            int birthDay = Integer.parseInt(m.group(4).substring(6));
            c.set(1, birthYear);
            c.set(2, birthMonth);
            c.set(5, birthDay);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            track.setBirthDate(c.getTime());
            return track;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String ln = System.getProperty("line.separator");
        sb.append("Identification Card - Track Two:").append(ln);
        sb.append("     Issuer Number: ").append(this.issuerNumber).append(ln);
        sb.append("         ID Number: ").append(this.idNumber).append(ln);
        sb.append("        Expiration: ").append(this.expiration).append(ln);
        sb.append("        Birth Date: ").append(this.birthDate).append(ln);
        return sb.toString();
    }

    public String getIssuerNumber() {
        return this.issuerNumber;
    }

    private void setIssuerNumber(String issuerNumber) {
        this.issuerNumber = issuerNumber;
    }

    public String getIdNumber() {
        return this.idNumber;
    }

    private void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    private void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    public Date getBirthDate() {
        return this.birthDate;
    }

    private void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }
}

