/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript.cardswipe;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IdentificationCardTrackOne {
    private String state;
    private String city;
    private String lastName;
    private String firstName;
    private String middleName;
    private String address;
    private String discretionaryData;

    public static IdentificationCardTrackOne parse(String trackData) {
        Pattern p = Pattern.compile(".*\\%([A-Z]{2})([A-Z\\.\\-' ]{1,13})\\^?([A-Z\\.\\-' \\$]{1,35})\\^?([^\\?^\\^]{1,29})\\^?\\?.*");
        Matcher m = p.matcher(trackData);
        if (m.matches()) {
            IdentificationCardTrackOne track = new IdentificationCardTrackOne();
            track.setState(m.group(1));
            track.setCity(m.group(2));
            track.setAddress(m.group(4));
            if (m.group(3).contains("\\$")) {
                String[] nameBits = m.group(3).split("\\$");
                if (nameBits.length > 0) {
                    track.setLastName(nameBits[0]);
                }
                if (nameBits.length > 1) {
                    track.setFirstName(nameBits[1]);
                }
                if (nameBits.length > 2) {
                    track.setMiddleName(nameBits[2]);
                }
            } else {
                String[] nameBits = m.group(3).split(" ");
                if (nameBits.length > 0) {
                    track.setFirstName(nameBits[0]);
                }
                if (nameBits.length == 2) {
                    track.setLastName(nameBits[1]);
                } else if (nameBits.length > 2) {
                    track.setMiddleName(nameBits[1]);
                    track.setLastName(nameBits[2]);
                }
                if (nameBits.length > 3) {
                    StringBuilder sb = new StringBuilder();
                    for (int x = 2; x < nameBits.length; ++x) {
                        sb.append(nameBits[x]);
                        if (x + 1 >= nameBits.length) continue;
                        sb.append(' ');
                    }
                    track.setLastName(sb.toString());
                }
            }
            return track;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String ln = System.getProperty("line.separator");
        sb.append("Identification Card - Track One:").append(ln);
        sb.append("             State: ").append(this.state).append(ln);
        sb.append("              City: ").append(this.city).append(ln);
        sb.append("        First Name: ").append(this.firstName).append(ln);
        sb.append("       Middle Name: ").append(this.middleName).append(ln);
        sb.append("         Last Name: ").append(this.lastName).append(ln);
        sb.append("        Expiration: ").append(this.address).append(ln);
        sb.append("Discretionary Data: ").append(this.discretionaryData).append(ln);
        return sb.toString();
    }

    public String getState() {
        return this.state;
    }

    private void setState(String state) {
        this.state = state;
    }

    public String getCity() {
        return this.city;
    }

    private void setCity(String city) {
        this.city = city;
    }

    public String getLastName() {
        return this.lastName;
    }

    private void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    private void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    private void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getAddress() {
        return this.address;
    }

    private void setAddress(String address) {
        this.address = address;
    }

    public String getDiscretionaryData() {
        return this.discretionaryData;
    }

    private void setDiscretionaryData(String discretionaryData) {
        this.discretionaryData = discretionaryData;
    }
}

