/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript.cardswipe;

import com.scriptel.proscript.cardswipe.IdentificationCardTrackOne;
import com.scriptel.proscript.cardswipe.IdentificationCardTrackThree;
import com.scriptel.proscript.cardswipe.IdentificationCardTrackTwo;

public final class IdentificationCard {
    private IdentificationCardTrackOne trackOne;
    private IdentificationCardTrackTwo trackTwo;
    private IdentificationCardTrackThree trackThree;

    public IdentificationCard(IdentificationCardTrackOne trackOne, IdentificationCardTrackTwo trackTwo, IdentificationCardTrackThree trackThree) {
        this.trackOne = trackOne;
        this.trackTwo = trackTwo;
        this.trackThree = trackThree;
    }

    private IdentificationCard() {
    }

    public static IdentificationCard parse(String cardData) {
        IdentificationCardTrackOne t1 = IdentificationCardTrackOne.parse(cardData);
        IdentificationCardTrackTwo t2 = IdentificationCardTrackTwo.parse(cardData);
        IdentificationCardTrackThree t3 = IdentificationCardTrackThree.parse(cardData);
        if (t1 != null || t2 != null || t3 != null) {
            IdentificationCard card = new IdentificationCard();
            card.setTrackOne(t1);
            card.setTrackTwo(t2);
            card.setTrackThree(t3);
            return card;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String ln = System.getProperty("line.separator");
        sb.append("Identification Card").append(ln);
        if (this.trackOne != null) {
            sb.append(this.trackOne).append(ln);
        }
        if (this.trackTwo != null) {
            sb.append(this.trackTwo).append(ln);
        }
        if (this.trackThree != null) {
            sb.append(this.trackThree).append(ln);
        }
        return sb.toString();
    }

    public IdentificationCardTrackOne getTrackOne() {
        return this.trackOne;
    }

    private void setTrackOne(IdentificationCardTrackOne trackOne) {
        this.trackOne = trackOne;
    }

    public IdentificationCardTrackTwo getTrackTwo() {
        return this.trackTwo;
    }

    private void setTrackTwo(IdentificationCardTrackTwo trackTwo) {
        this.trackTwo = trackTwo;
    }

    public IdentificationCardTrackThree getTrackThree() {
        return this.trackThree;
    }

    private void setTrackThree(IdentificationCardTrackThree trackThree) {
        this.trackThree = trackThree;
    }
}

