/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript.cardswipe;

import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum FinancialCardIssuer {
    AMERICAN_EXPRESS("American Express", "^(34|37)\\d{13}$"),
    DINERS_CLUB("Diners Club", "^(30[0-5]\\d{11}|36\\d{12})$"),
    CARTE_BLANCH("Carte Blanche", "^38\\d{12}$"),
    DISCOVER("Discover", "^6011\\d{12}$"),
    ENROUTE("EnRoute", "^(2131|1800)\\d{11}$"),
    JCB("JCB", "^(3\\d{15}|(2131|1800)\\d{11})$"),
    MASTER_CARD("Master Card", "^5[1-5]\\d{14}$"),
    VISA("Visa", "^4\\d{12,15}$"),
    UNKNOWN("Unknown", ".*");

    private String issuerName;
    private String regex;

    private FinancialCardIssuer(String issuerName, String regex) {
        this.issuerName = issuerName;
        this.regex = regex;
    }

    public static FinancialCardIssuer identifyByCardNumber(String number) {
        for (FinancialCardIssuer i : EnumSet.allOf(FinancialCardIssuer.class)) {
            Matcher m = i.getRegex().matcher(number);
            if (!m.find()) continue;
            return i;
        }
        return UNKNOWN;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public String getRegexString() {
        return this.regex;
    }

    public Pattern getRegex() {
        return Pattern.compile(this.regex);
    }
}

