/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript.cardswipe;

import com.scriptel.proscript.cardswipe.FinancialCardIssuer;
import com.scriptel.proscript.cardswipe.FinancialCardTrackOne;
import com.scriptel.proscript.cardswipe.FinancialCardTrackTwo;

public final class FinancialCard {
    private FinancialCardTrackOne trackOne;
    private FinancialCardTrackTwo trackTwo;
    private boolean numberValid;
    private FinancialCardIssuer issuer;

    public FinancialCard(FinancialCardTrackOne trackOne, FinancialCardTrackTwo trackTwo, boolean numberValid, FinancialCardIssuer issuer) {
        this.trackOne = trackOne;
        this.trackTwo = trackTwo;
        this.numberValid = numberValid;
        this.issuer = issuer;
    }

    private FinancialCard() {
    }

    public static FinancialCard parse(String cardData) {
        FinancialCardTrackOne t1 = FinancialCardTrackOne.parse(cardData);
        FinancialCardTrackTwo t2 = FinancialCardTrackTwo.parse(cardData);
        if (t1 != null || t2 != null) {
            FinancialCard card = new FinancialCard();
            card.setTrackOne(t1);
            card.setTrackTwo(t2);
            String cardNumber = t1 != null ? t1.getAccountNumber() : t2.getAccountNumber();
            card.setIssuer(FinancialCardIssuer.identifyByCardNumber(cardNumber));
            card.setNumberValid(FinancialCard.verifyCardChecksum(cardNumber));
            return card;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String ln = System.getProperty("line.separator");
        sb.append("Financial Card").append(ln);
        if (this.trackOne != null) {
            sb.append(this.trackOne).append(ln);
        }
        if (this.trackTwo != null) {
            sb.append(this.trackTwo).append(ln);
        }
        sb.append("Number Valid: ").append(this.numberValid).append(ln);
        sb.append("      Issuer: ").append((Object)this.issuer).append(ln);
        return sb.toString();
    }

    public static boolean verifyCardChecksum(String cardNumber) {
        int sum = 0;
        int flip = 0;
        int[][] table = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, {0, 2, 4, 6, 8, 1, 3, 5, 7, 9}};
        for (int i = cardNumber.length() - 1; i >= 0; --i) {
            sum += table[flip++ & 1][Integer.parseInt(Character.toString(cardNumber.charAt(i)))];
        }
        return sum % 10 == 0;
    }

    public FinancialCardTrackOne getTrackOne() {
        return this.trackOne;
    }

    private void setTrackOne(FinancialCardTrackOne trackOne) {
        this.trackOne = trackOne;
    }

    public FinancialCardTrackTwo getTrackTwo() {
        return this.trackTwo;
    }

    private void setTrackTwo(FinancialCardTrackTwo trackTwo) {
        this.trackTwo = trackTwo;
    }

    public boolean isNumberValid() {
        return this.numberValid;
    }

    private void setNumberValid(boolean numberValid) {
        this.numberValid = numberValid;
    }

    public FinancialCardIssuer getIssuer() {
        return this.issuer;
    }

    private void setIssuer(FinancialCardIssuer issuer) {
        this.issuer = issuer;
    }
}

