/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript.cardswipe;

import com.scriptel.proscript.cardswipe.FinancialCard;
import com.scriptel.proscript.cardswipe.FinancialCardIssuer;
import com.scriptel.proscript.cardswipe.FinancialCardTrackOne;
import com.scriptel.proscript.cardswipe.FinancialCardTrackTwo;
import com.scriptel.proscript.cardswipe.IdentificationCard;
import com.scriptel.proscript.cardswipe.IdentificationCardTrackOne;
import com.scriptel.proscript.cardswipe.IdentificationCardTrackThree;
import com.scriptel.proscript.cardswipe.IdentificationCardTrackTwo;

public class CardParser {
    private CardParser() {
        throw new IllegalStateException("Utility class");
    }

    public static FinancialCard parseFinancialCard(boolean trackOneValid, String trackOne, boolean trackTwoValid, String trackTwo) {
        FinancialCardTrackOne t1 = null;
        FinancialCardTrackTwo t2 = null;
        String cardNumber = null;
        if (trackOneValid && (t1 = FinancialCardTrackOne.parse(trackOne)) != null) {
            cardNumber = t1.getAccountNumber();
        }
        if (trackTwoValid && (t2 = FinancialCardTrackTwo.parse(trackTwo)) != null && cardNumber == null) {
            cardNumber = t2.getAccountNumber();
        }
        if (t1 != null || t2 != null) {
            FinancialCardIssuer issuer = FinancialCardIssuer.identifyByCardNumber(cardNumber);
            boolean valid = FinancialCard.verifyCardChecksum(cardNumber);
            return new FinancialCard(t1, t2, valid, issuer);
        }
        return null;
    }

    public static IdentificationCard parseIdentificationCard(boolean trackOneValid, String trackOne, boolean trackTwoValid, String trackTwo, boolean trackThreeValid, String trackThree) {
        IdentificationCardTrackOne t1 = null;
        IdentificationCardTrackTwo t2 = null;
        IdentificationCardTrackThree t3 = null;
        if (trackOneValid) {
            t1 = IdentificationCardTrackOne.parse(trackOne);
        }
        if (trackTwoValid) {
            t2 = IdentificationCardTrackTwo.parse(trackTwo);
        }
        if (trackThreeValid) {
            t3 = IdentificationCardTrackThree.parse(trackThree);
        }
        if (t1 != null || t2 != null || t3 != null) {
            return new IdentificationCard(t1, t2, t3);
        }
        return null;
    }
}

