/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript;

public class Version {
    private final int kernelVersionMajor;
    private final int kernelVersionMinor;
    private final int kernelVersionRelease;
    private final int firmwareVersionMajor;
    private final int firmwareVersionMinor;
    private final int firmwareVersionRelease;
    private final int asicSignature;

    private Version(int kernelVersionMajor, int kernelVersionMinor, int kernelVersionRelease, int firmwareVersionMajor, int firmwareVersionMinor, int firmwareVersionRelease, int asicSignature) {
        this.kernelVersionMajor = kernelVersionMajor;
        this.kernelVersionMinor = kernelVersionMinor;
        this.kernelVersionRelease = kernelVersionRelease;
        this.firmwareVersionMajor = firmwareVersionMajor;
        this.firmwareVersionMinor = firmwareVersionMinor;
        this.firmwareVersionRelease = firmwareVersionRelease;
        this.asicSignature = asicSignature;
    }

    public boolean firmwareBefore(int major, int minor, int release) {
        int fMajor = Version.toBCD((byte)this.firmwareVersionMajor);
        int fMinor = Version.toBCD((byte)this.firmwareVersionMinor);
        int fRelease = Version.toBCD((byte)this.firmwareVersionRelease);
        if (major > fMajor) {
            return true;
        }
        if (major == fMajor) {
            if (minor > fMinor) {
                return true;
            }
            if (minor == fMinor && release > fRelease) {
                return true;
            }
        }
        return false;
    }

    public boolean firmwareBefore(Version version) {
        return this.firmwareBefore(Version.toBCD((byte)version.getFirmwareVersionMajor()), Version.toBCD((byte)version.getFirmwareVersionMinor()), Version.toBCD((byte)version.getFirmwareVersionRelease()));
    }

    public boolean firmwareAfter(int major, int minor, int release) {
        int fMajor = Version.toBCD((byte)this.firmwareVersionMajor);
        int fMinor = Version.toBCD((byte)this.firmwareVersionMinor);
        int fRelease = Version.toBCD((byte)this.firmwareVersionRelease);
        if (major < fMajor) {
            return true;
        }
        if (major == fMajor) {
            if (minor < fMinor) {
                return true;
            }
            if (minor == fMinor && release < fRelease) {
                return true;
            }
        }
        return false;
    }

    public boolean firmwareAfter(Version version) {
        return this.firmwareAfter(Version.toBCD((byte)version.getFirmwareVersionMajor()), Version.toBCD((byte)version.getFirmwareVersionMinor()), Version.toBCD((byte)version.getFirmwareVersionRelease()));
    }

    public boolean firmwareEquals(Version version) {
        return this.firmwareEquals(Version.toBCD((byte)version.getFirmwareVersionMajor()), Version.toBCD((byte)version.getFirmwareVersionMinor()), Version.toBCD((byte)version.getFirmwareVersionRelease()));
    }

    public boolean firmwareEquals(int major, int minor, int release) {
        int fMajor = Version.toBCD((byte)this.firmwareVersionMajor);
        int fMinor = Version.toBCD((byte)this.firmwareVersionMinor);
        int fRelease = Version.toBCD((byte)this.firmwareVersionRelease);
        return major == fMajor && minor == fMinor && release == fRelease;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VersionInformation: \n");
        sb.append("         Kernel Version: ").append(this.getKernelVersionString()).append('\n');
        sb.append("     kernelVersionMajor: ").append(this.kernelVersionMajor).append('\n');
        sb.append("     kernelVersionMinor: ").append(this.kernelVersionMinor).append('\n');
        sb.append("   kernelVersionRelease: ").append(this.kernelVersionRelease).append('\n');
        sb.append("       Firmware Version: ").append(this.getFirmwareVersionString()).append('\n');
        sb.append("   firmwareVersionMajor: ").append(this.firmwareVersionMajor).append('\n');
        sb.append("   firmwareVersionMinor: ").append(this.firmwareVersionMinor).append('\n');
        sb.append(" firmwareVersionRelease: ").append(this.firmwareVersionRelease).append('\n');
        sb.append("          asicSignature: ").append(this.asicSignature).append('\n');
        return sb.toString();
    }

    public String getFirmwareVersionString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toHexString(this.firmwareVersionMajor));
        sb.append('.');
        sb.append(Integer.toHexString(this.firmwareVersionMinor));
        sb.append('.');
        sb.append(Integer.toHexString(this.firmwareVersionRelease));
        return sb.toString();
    }

    public String getKernelVersionString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toHexString(this.kernelVersionMajor));
        sb.append('.');
        sb.append(Integer.toHexString(this.kernelVersionMinor));
        sb.append('.');
        sb.append(Integer.toHexString(this.kernelVersionRelease));
        return sb.toString();
    }

    private static int toBCD(byte dec) {
        int retr = 0;
        retr += (dec >> 4 & 0xF) * 10;
        return retr += dec & 0xF;
    }

    private static int fromBCD(byte bcd) {
        int retr = 0;
        retr += bcd / 10 << 4;
        return retr += bcd % 10;
    }

    public int getKernelVersionMajor() {
        return this.kernelVersionMajor;
    }

    public int getKernelVersionMinor() {
        return this.kernelVersionMinor;
    }

    public int getKernelVersionRelease() {
        return this.kernelVersionRelease;
    }

    public int getFirmwareVersionMajor() {
        return this.firmwareVersionMajor;
    }

    public int getFirmwareVersionMinor() {
        return this.firmwareVersionMinor;
    }

    public int getFirmwareVersionRelease() {
        return this.firmwareVersionRelease;
    }

    public int getAsicSignature() {
        return this.asicSignature;
    }
}

