/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class Screen {
    public static final int DO_NOTHING_ON_NEXT = 255;
    private int number;
    private boolean resetTimeoutOnActivity;
    private int[] reserved = new int[14];
    private int timeout;
    private int timeoutNextScreen;
    private int[] regionIndexes = new int[0];
    private int[] screenNextList = new int[0];

    private Screen(int number, boolean resetTimeoutOnActivity, int[] reserved, int timeout, int timeoutNextScreen, int[] regionIndexes, int[] screenNextList) {
        this.number = number;
        this.resetTimeoutOnActivity = resetTimeoutOnActivity;
        this.reserved = reserved;
        this.timeout = timeout;
        this.timeoutNextScreen = timeoutNextScreen;
        this.regionIndexes = regionIndexes;
        this.screenNextList = screenNextList;
    }

    public Screen() {
    }

    public boolean equals(Object o) {
        if (!(o instanceof Screen)) {
            return false;
        }
        Screen s = (Screen)o;
        if (this.number != s.number) {
            return false;
        }
        if (this.resetTimeoutOnActivity != s.resetTimeoutOnActivity) {
            return false;
        }
        if (this.timeout != s.timeout) {
            return false;
        }
        if (this.timeoutNextScreen != s.timeoutNextScreen) {
            return false;
        }
        if (!Arrays.equals(this.regionIndexes, s.regionIndexes)) {
            return false;
        }
        return Arrays.equals(this.screenNextList, s.screenNextList);
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + this.number;
        hash = 61 * hash + (this.resetTimeoutOnActivity ? 1 : 0);
        hash = 61 * hash + this.timeout;
        hash = 61 * hash + this.timeoutNextScreen;
        hash = 61 * hash + Arrays.hashCode(this.regionIndexes);
        hash = 61 * hash + Arrays.hashCode(this.screenNextList);
        return hash;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("   Screen Information: \n");
        sb.append("                number: ").append(this.number).append("\n");
        sb.append("resetTimeoutOnActivity: ").append(this.resetTimeoutOnActivity).append("\n");
        sb.append("              reserved: ");
        for (i = 0; i < this.reserved.length; ++i) {
            sb.append(this.reserved[i]);
            if (i + 1 >= this.reserved.length) continue;
            sb.append(", ");
        }
        sb.append("\n");
        sb.append("               timeout: ").append(this.timeout).append("\n");
        sb.append("     timeoutNextScreen: ").append(this.timeoutNextScreen).append("\n");
        sb.append("         regionIndexes: ");
        for (i = 0; i < this.regionIndexes.length; ++i) {
            sb.append(this.regionIndexes[i]);
            if (i + 1 >= this.regionIndexes.length) continue;
            sb.append(", ");
        }
        sb.append("\n");
        sb.append("        screenNextList: ");
        for (i = 0; i < this.screenNextList.length; ++i) {
            sb.append(this.screenNextList[i]);
            if (i + 1 >= this.screenNextList.length) continue;
            sb.append(", ");
        }
        sb.append("\n");
        return sb.toString();
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public boolean getResetTimeoutOnActivity() {
        return this.resetTimeoutOnActivity;
    }

    public void setResetTimeoutOnActivity(boolean resetTimeoutOnActivity) {
        this.resetTimeoutOnActivity = resetTimeoutOnActivity;
    }

    public int[] getReserved() {
        return this.reserved;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeoutNextScreen() {
        return this.timeoutNextScreen;
    }

    public void setTimeoutNextScreen(int timeoutNextScreen) {
        this.timeoutNextScreen = timeoutNextScreen;
    }

    public void setRegions(Map<Integer, Integer> regions) {
        this.regionIndexes = new int[regions.size()];
        this.screenNextList = new int[regions.size()];
        int i = 0;
        for (Map.Entry<Integer, Integer> entry : regions.entrySet()) {
            this.regionIndexes[i] = entry.getKey();
            this.screenNextList[i] = entry.getValue();
            ++i;
        }
    }

    public void addRegion(int region) {
        this.addRegion(region, 255);
    }

    public void addRegion(int region, int next) {
        int len = this.regionIndexes.length;
        for (int i = 0; i < this.regionIndexes.length; ++i) {
            if (this.regionIndexes[i] != region) continue;
            this.screenNextList[i] = next;
            return;
        }
        int[] tempIndexes = new int[len + 1];
        int[] tempNext = new int[len + 1];
        System.arraycopy(this.regionIndexes, 0, tempIndexes, 0, len);
        System.arraycopy(this.screenNextList, 0, tempNext, 0, len);
        tempIndexes[len] = region;
        tempNext[len] = next;
        this.regionIndexes = tempIndexes;
        this.screenNextList = tempNext;
    }

    public int[] getRegionIndexes() {
        return this.regionIndexes;
    }

    public int[] getScreenNextList() {
        return this.screenNextList;
    }

    public Map<Integer, Integer> getRegionMap() {
        LinkedHashMap<Integer, Integer> map = new LinkedHashMap<Integer, Integer>();
        for (int i = 0; i < this.regionIndexes.length; ++i) {
            map.put(this.regionIndexes[i], this.screenNextList[i]);
        }
        return map;
    }
}

