/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript;

import com.scriptel.proscript.Resource;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class ResourceGraphic
extends Resource {
    private static final Logger LOGGER = Logger.getLogger(ResourceGraphic.class.getName());
    private BufferedImage graphic;
    private byte[] data;

    public ResourceGraphic() {
    }

    private ResourceGraphic(int resourceNumber, byte[] data) {
        super(resourceNumber);
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            this.graphic = ImageIO.read(in);
        }
        catch (IOException ex) {
            Logger.getLogger(ResourceGraphic.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.data = data;
    }

    public ResourceGraphic(int resourceNumber, BufferedImage graphic) {
        super(resourceNumber);
        if (graphic.getType() == 12) {
            this.graphic = graphic;
        } else {
            BufferedImage newImage = new BufferedImage(graphic.getWidth(), graphic.getHeight(), 12);
            Graphics2D g = newImage.createGraphics();
            g.drawImage(graphic, 0, 0, graphic.getWidth(), graphic.getHeight(), null);
            g.dispose();
            this.graphic = newImage;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.graphic, "BMP", baos);
            baos.flush();
            this.data = baos.toByteArray();
            baos.close();
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Problem reading image.", ex);
        }
    }

    @Override
    public String toString() {
        String pStr = super.toString();
        StringBuilder sb = new StringBuilder();
        sb.append(pStr);
        sb.append("         Graphic: \n");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.graphic, "BMP", baos);
            byte[] bytes = baos.toByteArray();
            sb.append("           graphic: ").append(bytes).append("\n");
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Problem writing image to byte array.", ex);
            sb.append("           graphic: INVALID BYTE DATA\n");
        }
        return sb.toString();
    }

    public BufferedImage getGraphic() {
        return this.graphic;
    }

    public void setGraphic(BufferedImage graphic) {
        this.graphic = graphic;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.graphic, "BMP", baos);
            baos.flush();
            this.data = baos.toByteArray();
            baos.close();
        }
        catch (IOException ex) {
            Logger.getLogger(ResourceGraphic.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            this.graphic = ImageIO.read(in);
        }
        catch (IOException ex) {
            Logger.getLogger(ResourceGraphic.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

