/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript;

public class PeripheralConfiguration {
    public static final int MAG_CARD_CONFIGURATION_OEM_EXTENDED = 1;
    public static final int MAG_CARD_CONFIGURATION_KEYBOARD = 4;
    public static final int MAG_CARD_CONFIGURATION_KEYBOARD_PREAMBLE = 8;
    private int magCardOutput;
    private boolean saveAsDefault;
    private boolean loadFactorySettings;

    private PeripheralConfiguration(int magCardOutput, boolean saveAsDefault, boolean loadFactorySettings) {
        this.magCardOutput = magCardOutput;
        this.saveAsDefault = saveAsDefault;
        this.loadFactorySettings = loadFactorySettings;
    }

    public PeripheralConfiguration() {
        this.magCardOutput = 0;
        this.saveAsDefault = false;
        this.loadFactorySettings = false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Peripheral Configuration:\n");
        sb.append("           magCardOutput: ");
        sb.append(this.getOutputs()).append('\n');
        sb.append("           saveAsDefault: ").append(this.getSaveAsDefault()).append('\n');
        sb.append("     loadFactorySettings: ").append(this.getLoadFactorySettings()).append('\n');
        return sb.toString();
    }

    private String getOutputs() {
        boolean valueListed = false;
        StringBuilder sb = new StringBuilder();
        if ((this.getMagCardOutput() & 1) == 1) {
            sb.append("OEM Format");
            valueListed = true;
        }
        if ((this.getMagCardOutput() & 4) == 4) {
            if (valueListed) {
                sb.append(", ");
            }
            sb.append("Keyboard");
            if ((this.getMagCardOutput() & 8) == 8) {
                sb.append(" with Preamble");
            } else {
                sb.append(" without Preamble");
            }
        }
        return sb.toString();
    }

    public int getMagCardOutput() {
        return this.magCardOutput;
    }

    public void setMagCardOutput(int magCardOutput) {
        this.magCardOutput = magCardOutput;
    }

    private boolean getSaveAsDefault() {
        return this.saveAsDefault;
    }

    public void setSaveAsDefault() {
        this.saveAsDefault = true;
    }

    private boolean getLoadFactorySettings() {
        return this.loadFactorySettings;
    }

    public void setLoadFactorySettings() {
        this.loadFactorySettings = true;
    }
}

