/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript;

public class OutputConfiguration {
    public static final int OUTPUT_MODE_REALTIME = 0;
    public static final int OUTPUT_MODE_ON_CONFIRM = 1;
    public static final int OUTPUT_MODE_ON_HOST_COMMAND = 2;
    public static final int COMPRESSION_MODE_LORES_UNCOMPRESSED = 0;
    public static final int COMPRESSION_MODE_LORES_COMPRESSED = 1;
    public static final int COMPRESSION_MODE_HIRES_UNCOMPRESSED = 2;
    public static final int COMPRESSION_MODE_HIRES_COMPRESSED = 3;
    public static final long OUTPUT_CONFIGURATION_OEM = 1L;
    public static final long OUTPUT_CONFIGURATION_OEM_EXTENDED = 2L;
    public static final long OUTPUT_CONFIGURATION_MOUSE = 256L;
    public static final long OUTPUT_CONFIGURATION_PEN_DIGITIZER = 512L;
    public static final long OUTPUT_CONFIGURATION_TOUCH = 1024L;
    public static final long OUTPUT_CONFIGURATION_KEYBOARD = 65536L;
    public static final long OUTPUT_CONFIGURATION_RAW_DATA = 0x40000000L;
    public static final long OUTPUT_CONFIGURATION_DEBUG_DATA = Integer.MIN_VALUE;
    private long outputReport;
    private int outputMode;
    private boolean compressionEnable;
    private boolean compressionHiRes;
    private int packetsPerSecond;
    private boolean saveAsDefault;
    private boolean loadFactorySettings;

    private OutputConfiguration(long outputReport, int outputMode, int compressionMode, int packetsPerSecond, boolean saveAsDefault, boolean loadFactorySettings) {
        this.outputReport = outputReport;
        this.outputMode = outputMode;
        this.compressionEnable = (compressionMode & 1) == 1;
        this.compressionHiRes = (compressionMode & 2) == 2;
        this.packetsPerSecond = packetsPerSecond;
        this.saveAsDefault = saveAsDefault;
        this.loadFactorySettings = loadFactorySettings;
    }

    public OutputConfiguration() {
        this.outputReport = 0L;
        this.outputMode = 0;
        this.compressionEnable = false;
        this.compressionHiRes = false;
        this.packetsPerSecond = 0;
        this.saveAsDefault = false;
        this.loadFactorySettings = false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OutputConfiguration:\n");
        sb.append("           outputReport: ").append("0x").append(Long.toHexString(this.getOutputReport())).append('\n');
        sb.append("             outputMode: ").append(this.getOutputMode()).append('\n');
        sb.append("     compresseionEnable: ").append(this.isCompressionEnabled()).append('\n');
        sb.append("       compressionHiRes: ").append(this.isCompressionHiRes()).append('\n');
        sb.append("       packetsPerSecond: ").append(this.getPacketsPerSecond()).append('\n');
        sb.append("          saveAsDefault: ").append(this.getSaveAsDefault()).append('\n');
        sb.append("    loadFactorySettings: ").append(this.getLoadFactorySettings()).append('\n');
        return sb.toString();
    }

    public long getOutputReport() {
        return this.outputReport;
    }

    public void setOutputReport(long outputReport) {
        this.outputReport = outputReport;
    }

    public int getOutputMode() {
        return this.outputMode;
    }

    public void setOutputMode(int outputMode) {
        this.outputMode = outputMode;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnable;
    }

    public void setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnable = compressionEnabled;
    }

    public boolean isCompressionHiRes() {
        return this.compressionHiRes;
    }

    public void setCompressionHiRes(boolean hiRes) {
        this.compressionHiRes = hiRes;
    }

    public int getCompressionMode() {
        int mode = this.isCompressionEnabled() ? 1 : 0;
        return mode |= this.isCompressionHiRes() ? 2 : 0;
    }

    public void setCompressionMode(int mode) {
        this.compressionEnable = (mode & 1) == 1;
        this.compressionHiRes = (mode & 2) == 2;
    }

    public int getPacketsPerSecond() {
        return this.packetsPerSecond;
    }

    public void setPacketsPerSecond(int packetsPerSecond) {
        this.packetsPerSecond = packetsPerSecond;
    }

    private boolean getSaveAsDefault() {
        return this.saveAsDefault;
    }

    public void setSaveAsDefault() {
        this.saveAsDefault = true;
    }

    private boolean getLoadFactorySettings() {
        return this.loadFactorySettings;
    }

    public void setLoadFactorySettings() {
        this.loadFactorySettings = true;
    }
}

