/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript;

public final class OperatingModes {
    public static final int ACQMODE_TOUCH = 0;
    public static final int ACQMODE_PEN = 1;
    public static final int ACQMODE_AUTOTOUCH = 2;
    public static final int MODE_SINGLE = 0;
    public static final int MODE_SINGLE_LIFTOFF = 1;
    public static final int MODE_STREAM = 2;
    public static final int MODE_STREAM_LIFTOFF = 3;
    public static final int MODE_CONTINUOUS = 4;
    private final int supportedModes;
    private final int reserved;
    private final int acquisitionMode;
    private final int touchMode;
    private final int penMode;
    private final boolean touchModeSupported;
    private final boolean penModeSupported;
    private final boolean autoTouchModeSupported;

    private OperatingModes(int supportedModes, int reserved, int acquisitionMode, int touchMode, int penMode) {
        this.supportedModes = supportedModes;
        this.reserved = reserved;
        this.acquisitionMode = acquisitionMode;
        this.touchMode = touchMode;
        this.penMode = penMode;
        this.touchModeSupported = (this.supportedModes & 1) > 0;
        this.penModeSupported = (this.supportedModes & 2) > 0;
        this.autoTouchModeSupported = (this.supportedModes & 4) > 0;
    }

    public static String getAcqModeString(int acqMode) {
        switch (acqMode) {
            case 0: {
                return "ACQMODE_TOUCH";
            }
            case 1: {
                return "ACQMODE_PEN";
            }
            case 2: {
                return "ACQMODE_AUTOTOUCH";
            }
        }
        return "Unknown";
    }

    public static String getModeString(int mode) {
        switch (mode) {
            case 0: {
                return "MODE_SINGLE";
            }
            case 1: {
                return "MODE_SINGLE_LIFTOFF";
            }
            case 2: {
                return "MODE_STREAM";
            }
            case 3: {
                return "MODE_STREAM_LIFTOFF";
            }
            case 4: {
                return "MODE_CONTINUOUS";
            }
        }
        return "Unknown";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OperatingModes: \n");
        sb.append("  supportedModes: ").append(this.supportedModes).append("\n");
        if (this.touchModeSupported) {
            sb.append("                  ACQMODE_TOUCH\n");
        }
        if (this.penModeSupported) {
            sb.append("                  ACQMODE_PEN\n");
        }
        if (this.autoTouchModeSupported) {
            sb.append("                  ACQMODE_AUTOTOUCH\n");
        }
        sb.append("        reserved: ").append(this.reserved).append("\n");
        sb.append(" acquisitionMode: (").append(this.acquisitionMode).append(") - ").append(OperatingModes.getAcqModeString(this.acquisitionMode)).append("\n");
        sb.append("       touchMode: (").append(this.touchMode).append(") - ").append(OperatingModes.getModeString(this.touchMode)).append("\n");
        sb.append("         penMode: (").append(this.penMode).append(") - ").append(OperatingModes.getModeString(this.penMode)).append("\n");
        return sb.toString();
    }

    public int getSupportedModes() {
        return this.supportedModes;
    }

    public int getReserved() {
        return this.reserved;
    }

    public int getAcquisitionMode() {
        return this.acquisitionMode;
    }

    public int getTouchMode() {
        return this.touchMode;
    }

    public int getPenMode() {
        return this.penMode;
    }
}

