/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript;

import java.util.Arrays;

public final class FirmwarePage {
    public static final int PAGE_SIZE = 128;
    private int address;
    private byte[] data;
    private byte checksum;

    public FirmwarePage(int address, byte[] data) {
        this.address = address;
        this.data = data;
        this.recalculateChecksum();
    }

    public FirmwarePage(int address, byte[] data, byte checksum) {
        this.address = address;
        this.data = data;
        this.checksum = checksum;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FirmwarePage)) {
            return false;
        }
        FirmwarePage p = (FirmwarePage)o;
        if (this.address != p.address || this.checksum != p.checksum) {
            return false;
        }
        return Arrays.equals(this.data, p.data);
    }

    public void recalculateChecksum() {
        long ck = 0L;
        ck -= (long)(this.address & 0xFF);
        ck -= (long)(this.address >> 8 & 0xFF);
        ck -= (long)(this.address >> 16 & 0xFF);
        ck -= (long)(this.address >> 24 & 0xFF);
        for (byte b : this.data) {
            ck -= (long)b;
        }
        this.checksum = (byte)(ck & 0xFFL);
    }

    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + this.address;
        hash = 83 * hash + Arrays.hashCode(this.data);
        hash = 83 * hash + this.checksum;
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FirmwarePage:\n");
        sb.append("   Address: ").append(this.address).append('\n');
        sb.append("      Data: ");
        for (byte b : this.data) {
            String bit = Integer.toHexString(b & 0xFF);
            if (bit.length() == 1) {
                sb.append('0');
                sb.append(bit);
                continue;
            }
            sb.append(bit);
        }
        sb.append('\n');
        sb.append("  Checksum: ").append(this.checksum).append('\n');
        return sb.toString();
    }

    public int getAddress() {
        return this.address;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte getChecksum() {
        return this.checksum;
    }

    public void setChecksum(byte checksum) {
        this.checksum = checksum;
    }
}

