/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript;

import com.scriptel.proscript.ErrorCorrectionSample;
import com.scriptel.proscript.firmware.SRECRecord;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ErrorCorrectionTable {
    private static final Logger LOGGER = Logger.getLogger(ErrorCorrectionTable.class.getName());
    private final byte[] table;
    private final int xMin;
    private final int xDelta;
    private final int yMin;
    private final int yDelta;
    private final int xOffset;
    private final int yOffset;
    private byte checksum;
    private boolean valid;
    private final List<ErrorCorrectionSample> samples = new ArrayList<ErrorCorrectionSample>();
    private int boundX1 = Integer.MAX_VALUE;
    private int boundX2 = Integer.MIN_VALUE;
    private int boundY1 = Integer.MAX_VALUE;
    private int boundY2 = Integer.MIN_VALUE;

    public ErrorCorrectionTable(byte[] table) {
        int i;
        if (table == null || table.length < 21) {
            throw new IllegalArgumentException("Error correction table is either null or is too short.");
        }
        this.table = table;
        this.xMin = ((table[1] & 0xFF) << 8) + (table[2] & 0xFF);
        this.xDelta = ((table[3] & 0xFF) << 8) + (table[4] & 0xFF);
        this.yMin = ((table[5] & 0xFF) << 8) + (table[6] & 0xFF);
        this.yDelta = ((table[7] & 0xFF) << 8) + (table[8] & 0xFF);
        this.xOffset = table[17] & 0xFF;
        this.yOffset = table[18] & 0xFF;
        for (i = 19; i < table.length - 1; i += 3) {
            int x = ((table[i] & 0xFF) << 4) + ((table[i + 1] & 0xF0) >> 4);
            int y = ((table[i + 2] & 0xFF) << 4) + (table[i + 1] & 0xF);
            if (x < this.boundX1) {
                this.boundX1 = x;
            }
            if (x > this.boundX2) {
                this.boundX2 = x;
            }
            if (y < this.boundY1) {
                this.boundY1 = y;
            }
            if (y > this.boundY2) {
                this.boundY2 = y;
            }
            this.samples.add(new ErrorCorrectionSample(x, y));
        }
        this.checksum = 0;
        for (i = 0; i < table.length - 1; ++i) {
            this.checksum = (byte)(this.checksum + table[i]);
        }
        this.checksum = (byte)(165 - this.checksum);
        this.valid = this.checksum == table[table.length - 1] && (table[0] & 0xFF) == 254;
    }

    public void toSrecord(Writer writer) throws IOException {
        int startAddress = 28672;
        int pageSize = 32;
        for (int x = 0; x < this.getTable().length; x += pageSize) {
            writer.write("S1");
            writer.write(this.toHex(pageSize + 3, 2));
            writer.write(this.toHex(startAddress + x, 4));
            int sum = 0;
            sum = (byte)(sum + (pageSize + 3));
            sum = (byte)(sum + (startAddress + x >> 8));
            sum = (byte)(sum + (startAddress + x & 0xFF));
            int i = x;
            for (int j = 0; i < this.getTable().length && j < pageSize; ++i, ++j) {
                writer.write(this.toHex(this.getTable()[i] & 0xFF, 2));
                sum = (byte)(sum + this.getTable()[i]);
            }
            sum = (byte)(255 - sum);
            writer.write(this.toHex(sum & 0xFF, 2));
            writer.write("\r\n");
        }
        writer.write("S9030000FC\r\n");
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ErrorCorrectionTable fromSrecord(BufferedReader reader) throws IOException {
        int address = 28672;
        ByteArrayOutputStream bos = null;
        try {
            String line;
            bos = new ByteArrayOutputStream();
            while ((line = reader.readLine()) != null) {
                SRECRecord record = new SRECRecord(line);
                if (record.getType() == 1) {
                    byte[] data = record.getData();
                    if (data.length != 32) {
                        throw new IOException("Unexpected data length: " + data.length);
                    }
                    if (record.getAddress() != (long)address) {
                        throw new IOException("Unexpected address: " + record.getAddress());
                    }
                    bos.write(data);
                    address += 32;
                    continue;
                }
                if (record.getType() == 9) continue;
                throw new IOException("Unexpected SRecord type in error correction table: S" + record.getType());
            }
            ErrorCorrectionTable errorCorrectionTable = new ErrorCorrectionTable(bos.toByteArray());
            return errorCorrectionTable;
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, "Unable to close output stream.", e);
                }
            }
        }
    }

    private String toHex(int num, int len) {
        StringBuilder str = new StringBuilder(len);
        str.append(Integer.toHexString(num).toUpperCase());
        while (str.length() < len) {
            str.insert(0, '0');
        }
        return str.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ErrorCorrectionTable)) {
            return false;
        }
        ErrorCorrectionTable e = (ErrorCorrectionTable)o;
        if (this.xMin != e.xMin || this.xDelta != e.xDelta || this.yMin != e.yMin || this.yDelta != e.yDelta || this.xOffset != e.xOffset || this.yOffset != e.yOffset || this.checksum != e.checksum || this.valid != e.valid) {
            return false;
        }
        return this.samples.equals(e.samples);
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + this.xMin;
        hash = 53 * hash + this.xDelta;
        hash = 53 * hash + this.yMin;
        hash = 53 * hash + this.yDelta;
        hash = 53 * hash + this.xOffset;
        hash = 53 * hash + this.yOffset;
        hash = 53 * hash + this.checksum;
        hash = 53 * hash + (this.valid ? 1 : 0);
        hash = 53 * hash + this.samples.hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Error Correction Table:\n");
        sb.append("     xMin: ").append(this.xMin).append('\n');
        sb.append("   xDelta: ").append(this.xDelta).append('\n');
        sb.append("     yMin: ").append(this.yMin).append('\n');
        sb.append("   yDelta: ").append(this.yDelta).append('\n');
        sb.append("  xOffset: ").append(this.xOffset).append('\n');
        sb.append("  yOffset: ").append(this.yOffset).append('\n');
        sb.append(" checksum: ").append(this.checksum & 0xFF).append('\n');
        sb.append("    valid: ").append(this.valid).append('\n');
        sb.append("  boundX1: ").append(this.boundX1).append('\n');
        sb.append("  boundY1: ").append(this.boundY1).append('\n');
        sb.append("  boundX2: ").append(this.boundX2).append('\n');
        sb.append("  boundY2: ").append(this.boundY2).append('\n');
        for (ErrorCorrectionSample sample : this.samples) {
            sb.append(sample);
        }
        return sb.toString();
    }

    public int getxMin() {
        return this.xMin;
    }

    public int getxDelta() {
        return this.xDelta;
    }

    public int getyMin() {
        return this.yMin;
    }

    public int getyDelta() {
        return this.yDelta;
    }

    public int getxOffset() {
        return this.xOffset;
    }

    public int getyOffset() {
        return this.yOffset;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public boolean isValid() {
        return this.valid;
    }

    public List<ErrorCorrectionSample> getSamples() {
        return this.samples;
    }

    public int getBoundX1() {
        return this.boundX1;
    }

    public int getBoundX2() {
        return this.boundX2;
    }

    public int getBoundY1() {
        return this.boundY1;
    }

    public int getBoundY2() {
        return this.boundY2;
    }

    public byte[] getTable() {
        return this.table;
    }
}

