/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript;

import com.scriptel.proscript.input.AdjustedCoordinate;

public final class Display {
    private final int width;
    private final int height;
    private final int colorDepth;
    private final int textWidth;
    private final int textHeight;
    private final int regionCount;
    private final int captionLength;

    private Display(int width, int height, int colorDepth, int textWidth, int textHeight, int regionCount, int captionLength) {
        this.width = width;
        this.height = height;
        this.colorDepth = colorDepth;
        this.textWidth = textWidth;
        this.textHeight = textHeight;
        this.regionCount = regionCount;
        this.captionLength = captionLength;
    }

    public void adjustAspect(AdjustedCoordinate coordinate) {
        if (!coordinate.isRangeCorrected()) {
            throw new IllegalArgumentException("The coordinate must be range corrected before it can be aspect corrected.");
        }
        if (coordinate.isAspectCorrected()) {
            throw new IllegalArgumentException("The coordinate is already aspect corrected.");
        }
        coordinate.setX(coordinate.getX() * (double)this.width);
        coordinate.setY(coordinate.getY() * (double)this.height);
        coordinate.setAspectCorrected(true);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DisplayInformation: \n");
        sb.append("           width: ").append(this.width).append("\n");
        sb.append("          height: ").append(this.height).append("\n");
        sb.append("      colorDepth: ").append(this.colorDepth).append("\n");
        sb.append("       textWidth: ").append(this.textWidth).append("\n");
        sb.append("      textHeight: ").append(this.textHeight).append("\n");
        sb.append("     regionCount: ").append(this.regionCount).append("\n");
        sb.append("   captionLength: ").append(this.captionLength).append("\n");
        return sb.toString();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getColorDepth() {
        return this.colorDepth;
    }

    public int getTextWidth() {
        return this.textWidth;
    }

    public int getTextHeight() {
        return this.textHeight;
    }

    public int getRegionCount() {
        return this.regionCount;
    }

    public int getCaptionLength() {
        return this.captionLength;
    }
}

