/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript;

import com.scriptel.proscript.Device;
import com.scriptel.proscript.DeviceNotificationListener;
import com.scriptel.proscript.nativelib.NativeLoader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DeviceManager {
    private static final Logger LOGGER = Logger.getLogger(DeviceManager.class.getName());
    private static final int WRAPPER_VERSION_MAJOR = 2;
    private static final int WRAPPER_VERSION_MINOR = 2;
    private static final int WRAPPER_VERSION_RELEASE = 79;
    private static final String WRAPPER_BUILD_DATE = "2023-04-11 05:54:25+0000";
    private static final int DEVICE_ADDED = 0;
    private static final int DEVICE_REMOVED = 1;
    private static final List<DeviceNotificationListener> LISTENERS = new ArrayList<DeviceNotificationListener>();
    private static Device[] deviceList;
    private static String nativeInitErrorMessage;

    private DeviceManager() {
    }

    public static String getInitialErrorMessage() {
        return nativeInitErrorMessage;
    }

    public static native Device[] getAttachedDevices() throws IOException;

    public static void registerDeviceListener(DeviceNotificationListener listener) {
        DeviceManager.registerDeviceListener(listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDeviceListener(DeviceNotificationListener listener, boolean sendCached) {
        List<DeviceNotificationListener> list = LISTENERS;
        synchronized (list) {
            LISTENERS.add(listener);
            if (sendCached) {
                for (Device d : deviceList) {
                    listener.receiveDeviceAttachedNotification(d.getPath(), d);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterDeviceListener(DeviceNotificationListener listener) {
        List<DeviceNotificationListener> list = LISTENERS;
        synchronized (list) {
            LISTENERS.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pushDeviceNotification(int type, String path) {
        if (type == 0) {
            try {
                deviceList = DeviceManager.getAttachedDevices();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "There was a problem enumerating devices for hotplug notification.", e);
            }
        }
        Device d = DeviceManager.lookupDevice(path);
        List<DeviceNotificationListener> list = LISTENERS;
        synchronized (list) {
            for (DeviceNotificationListener l : LISTENERS) {
                if (type == 0) {
                    l.receiveDeviceAttachedNotification(path, d);
                    continue;
                }
                l.receiveDeviceDetachedNotification(path, d);
            }
        }
        if (type == 1) {
            try {
                deviceList = DeviceManager.getAttachedDevices();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "There was a problem enumerating devices for hotplug notification.", e);
            }
        }
    }

    private static Device lookupDevice(String path) {
        for (Device d : deviceList) {
            String devPath = d.getPath();
            if (!devPath.equalsIgnoreCase(path)) continue;
            return d;
        }
        return null;
    }

    private static native void init();

    public static native void destroy();

    public static String getWrapperVersion() {
        return "2.2.79";
    }

    public static int getWrapperVersionMajor() {
        return 2;
    }

    public static int getWrapperVersionMinor() {
        return 2;
    }

    public static int getWrapperVersionRelease() {
        return 79;
    }

    public static Date getWrapperBuildDate() {
        if (WRAPPER_BUILD_DATE.isEmpty()) {
            return new Date();
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
        try {
            return fmt.parse(WRAPPER_BUILD_DATE);
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public static native String getLibraryVersion();

    public static native int getLibraryVersionMajor();

    public static native int getLibraryVersionMinor();

    public static native int getLibraryVersionRelease();

    private static native String getLibraryBuildDateString();

    public static Date getLibraryBuildDate() {
        String buildDate = DeviceManager.getLibraryBuildDateString();
        if (buildDate.isEmpty()) {
            return new Date();
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
        try {
            return fmt.parse(buildDate);
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    static {
        nativeInitErrorMessage = null;
        try {
            NativeLoader.load();
            DeviceManager.init();
            deviceList = DeviceManager.getAttachedDevices();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "There was a problem loading native libraries for the ProScript library.", e);
            nativeInitErrorMessage = e.getMessage();
        }
    }
}

