/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript;

import com.scriptel.proscript.CalibrationData;
import com.scriptel.proscript.CalibrationState;
import com.scriptel.proscript.Capabilities;
import com.scriptel.proscript.Configuration;
import com.scriptel.proscript.CoordinateRange;
import com.scriptel.proscript.DeviceStatus;
import com.scriptel.proscript.Display;
import com.scriptel.proscript.DisplayChunk;
import com.scriptel.proscript.DisplaySettings;
import com.scriptel.proscript.FirmwareListener;
import com.scriptel.proscript.FirmwarePage;
import com.scriptel.proscript.FrequencyAmplitude;
import com.scriptel.proscript.GeneralParameters;
import com.scriptel.proscript.InputListener;
import com.scriptel.proscript.OperatingModes;
import com.scriptel.proscript.OutputConfiguration;
import com.scriptel.proscript.PenParameters;
import com.scriptel.proscript.PeripheralConfiguration;
import com.scriptel.proscript.RawInputListener;
import com.scriptel.proscript.Region;
import com.scriptel.proscript.Resource;
import com.scriptel.proscript.ResourceAvailability;
import com.scriptel.proscript.ResourceGraphic;
import com.scriptel.proscript.ResourceInfo;
import com.scriptel.proscript.Screen;
import com.scriptel.proscript.ScreenModify;
import com.scriptel.proscript.ScreenRegionInfo;
import com.scriptel.proscript.TouchParameters;
import com.scriptel.proscript.TuningStatus;
import com.scriptel.proscript.Version;
import com.scriptel.proscript.firmware.FWFirmwarePackage;
import com.scriptel.proscript.firmware.FirmwarePackage;
import com.scriptel.proscript.firmware.FirmwareRestriction;
import com.scriptel.proscript.firmware.SRECFirmwarePackage;
import com.scriptel.proscript.input.ADCChannelValues;
import com.scriptel.proscript.input.ADCScanValues;
import com.scriptel.proscript.input.ButtonEvent;
import com.scriptel.proscript.input.Coordinate;
import com.scriptel.proscript.input.DebugCoordinate;
import com.scriptel.proscript.input.MagneticCardSwipe;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public final class Device {
    public static final int POWER_STATE_NORMAL = 0;
    public static final int POWER_STATE_POWERDOWN = 1;
    public static final int POWER_STATE_STANDBY = 2;
    public static final int RUNMODE_COMMAND = 0;
    public static final int RUNMODE_TOUCH = 1;
    public static final int RUNMODE_PEN = 2;
    public static final int RUNMODE_AUTOTOUCH = 4;
    public static final int RUNMODE_TOUCHSINGLE = 8;
    public static final int RUNMODE_TOUCHSTREAM = 10;
    public static final int RUNMODE_PENSINGLE = 16;
    public static final int RUNMODE_PENSTREAM = 18;
    public static final int RUNMODE_PENCONTINUOUS = 20;
    public static final int TEXTALIGN_LEFT = 0;
    public static final int TEXTALIGN_RIGHT = 1;
    public static final int TEXTALIGN_CENTER = 2;
    public static final int DEVICE_DISCARD_CHANGES = 0;
    public static final int DEVICE_SAVE_CHANGES = 1;
    public static final int DEVICE_FACTORY_RESET = 90;
    public static final int SIMULATE_COORD_DISPLAY_SPACE = 1;
    public static final int SIMULATE_COORD_DEVICE_SPACE = 2;
    private long ptr;
    private long driverPtr;
    private long driverDefinedPtr;
    private final String path;
    private final int productId;
    private final int vendorId;
    private final String model;
    private final String manufacturer;
    private final List<InputListener> listeners = new ArrayList<InputListener>();
    private final List<RawInputListener> rawListeners = new ArrayList<RawInputListener>();
    private final IndexColorModel colorModel4Bit = new IndexColorModel(4, 16, new int[]{0, 0x800000, 32768, 0x808000, 128, 0x800080, 32896, 0x808080, 0xC0C0C0, 0xFF0000, 65280, 0xFFFF00, 255, 0xFF00FF, 65535, 0xFFFFFF}, 0, false, 1, 0);

    private Device(String path, int productId, int vendorId, String model, String manufacturer) {
        this.path = path;
        this.productId = productId;
        this.vendorId = vendorId;
        this.model = model;
        this.manufacturer = manufacturer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        StringBuilder pid = new StringBuilder(Integer.toString(this.productId, 16));
        StringBuilder vid = new StringBuilder(Integer.toString(this.vendorId, 16));
        while (pid.length() < 4) {
            pid.insert(0, '0');
        }
        while (vid.length() < 4) {
            vid.insert(0, '0');
        }
        sb.append(this.manufacturer).append(' ').append(this.model);
        sb.append(" (").append((CharSequence)vid).append(':').append((CharSequence)pid).append(')');
        return sb.toString();
    }

    public native void open() throws IOException;

    public native byte[] getUuid() throws IOException;

    public native byte[] getGENIIGuid() throws IOException;

    public native void setGENIIGuid(byte[] var1) throws IOException;

    public native boolean isOpen();

    public native boolean isButtonDown();

    public native Capabilities getCapabilities() throws IOException;

    public native Display getDisplayInfo() throws IOException;

    public native DisplaySettings getDisplaySettings() throws IOException;

    public native CoordinateRange getCoordinateRange() throws IOException;

    public native Version getVersionInfo() throws IOException;

    @Deprecated
    public native Region[] getRegions() throws IOException;

    public native void read() throws IOException;

    public native void close() throws IOException;

    public native byte[] getErrorCorrectionTable() throws IOException;

    public native String getSerialNumber() throws IOException;

    public native int getPowerState() throws IOException;

    public native OperatingModes getOperatingModes() throws IOException;

    public native GeneralParameters getGeneralParameters() throws IOException;

    public native FrequencyAmplitude getFrequencyAmplitude() throws IOException;

    public native byte[] getAsicRegister() throws IOException;

    public native PenParameters getPenParameters() throws IOException;

    public native OutputConfiguration getOutputConfiguration() throws IOException;

    public native void setOutputConfiguration(OutputConfiguration var1) throws IOException;

    public native PeripheralConfiguration getPeripheralConfiguration() throws IOException;

    public native void setPeripheralConfiguration(PeripheralConfiguration var1) throws IOException;

    public native int getResourceIndex() throws IOException;

    public native void setResourceIndex(int var1) throws IOException;

    public native ResourceInfo getResourceInfo() throws IOException;

    public native ResourceAvailability getResourceAvailability() throws IOException;

    public native Resource getResource() throws IOException;

    private native void setResourceImpl(Resource var1) throws IOException;

    public native void deleteResource(int var1) throws IOException;

    public native int getRegionIndex() throws IOException;

    public native void setRegionIndex(int var1) throws IOException;

    public native Region getDeviceRegion() throws IOException;

    public native Region[] getDeviceRegions() throws IOException;

    public native void setDeviceRegion(Region var1) throws IOException;

    public native void deleteDeviceRegion(int var1) throws IOException;

    public native int getScreenIndex() throws IOException;

    public native void setScreenIndex(int var1) throws IOException;

    public native Screen getScreen() throws IOException;

    public native void setScreen(Screen var1) throws IOException;

    public native void deleteScreen(int var1) throws IOException;

    public native void modifyScreen(ScreenModify var1) throws IOException;

    public native ScreenRegionInfo getScreenRegionInfo() throws IOException;

    public native int getActiveScreen() throws IOException;

    public native void setActiveScreen(int var1) throws IOException;

    public native CalibrationData getCalibrationData() throws IOException;

    public native void setCalibrationData(CalibrationData var1) throws IOException;

    public native DeviceStatus getDeviceStatus() throws IOException;

    public native void clearLastError() throws IOException;

    public native TouchParameters getTouchParameters() throws IOException;

    public native CalibrationState getCalibrationState() throws IOException;

    public native int getContactCountMaximum() throws IOException;

    public native Configuration getConfiguration() throws IOException;

    @Deprecated
    public native Region[] getDefaultRegions() throws IOException;

    public native void restoreDefaultRegions() throws IOException;

    public native void setRunMode(int var1) throws IOException;

    public native void setSerialNumber(String var1) throws IOException;

    public native void clearScreen() throws IOException;

    @Deprecated
    public native void deleteRegion(int var1) throws IOException;

    public native void setDisplaySettings(DisplaySettings var1) throws IOException;

    public native void setDeviceConfiguration(Configuration var1) throws IOException;

    public native void setFrequencyAmplitude(FrequencyAmplitude var1) throws IOException;

    public native void setPowerState(int var1) throws IOException;

    private native void setFirmwarePage(FirmwarePage var1) throws IOException;

    private native void setFirmwareComplete() throws IOException;

    public native void setErrorCorrectionTable(byte[] var1) throws IOException;

    public native void setStartupMode(int var1) throws IOException;

    public native void setGeneralParameters(GeneralParameters var1) throws IOException;

    public native void asicReset(boolean var1) throws IOException;

    public native void setAsicRegister(byte var1, byte var2) throws IOException;

    public native void setPenParameters(PenParameters var1) throws IOException;

    public native void setTouchParameters(TouchParameters var1) throws IOException;

    public native void setPrimaryRegion(int var1) throws IOException;

    public native void writeDisplayChunk(DisplayChunk var1) throws IOException;

    @Deprecated
    public native void setRegion(Region var1) throws IOException;

    @Deprecated
    public native void updateRegion(Region var1) throws IOException;

    @Deprecated
    public native void saveRegions(boolean var1) throws IOException;

    public native void saveScreensRegions(int var1) throws IOException;

    public native void calibrate() throws IOException;

    public native void cancelCalibration() throws IOException;

    public native void drawText(String var1, int var2, int var3, int var4, boolean var5);

    public native int getTextWidth(String var1);

    public native int getTextHeight(String var1);

    public native int getGENIIConfiguration() throws IOException;

    public native void setGENIIPID(int var1) throws IOException;

    public native void GENIITune();

    public native void GENIIAbortTune();

    public native TuningStatus getGENIITuningStatus() throws IOException;

    public native String getDriverName() throws IOException;

    public native void setProscriptMode(boolean var1) throws IOException;

    public native void setEasyscriptMode(boolean var1) throws IOException;

    public void registerInputListener(InputListener l) {
        this.listeners.add(l);
    }

    public void unregisterInputListener(InputListener l) {
        this.listeners.remove(l);
    }

    private void registerRawInputListener(RawInputListener l) {
        this.rawListeners.add(l);
    }

    private void unregisterRawInputListener(RawInputListener l) {
        this.rawListeners.remove(l);
    }

    private void pushCoordinateEvent(Coordinate c) {
        for (InputListener l : this.listeners) {
            l.recieveCoordinateEvent(c);
        }
    }

    private void pushMagneticCardSwipeEvent(MagneticCardSwipe c) {
        for (InputListener l : this.listeners) {
            l.recieveMagneticStripEvent(c);
        }
    }

    private void pushButtonEvent(ButtonEvent e) {
        for (InputListener l : this.listeners) {
            l.receiveButtonEvent(e);
        }
    }

    private void pushDebugCoordinateEvent(DebugCoordinate c) {
        for (InputListener l : this.listeners) {
            l.recieveDebugCoordinateEvent(c);
        }
    }

    private void pushADCScanValuesEvent(ADCScanValues v) {
        for (InputListener l : this.listeners) {
            l.recieveADCScanValues(v);
        }
    }

    private void pushADCChannelValuesEvent(ADCChannelValues v) {
        for (InputListener l : this.listeners) {
            l.recieveADCChannelValues(v);
        }
    }

    private void pushRawInputReport(byte[] report) {
        for (RawInputListener l : this.rawListeners) {
            l.receiveInputReport(report);
        }
    }

    public String getUuidString() throws IOException {
        int i;
        byte[] uuid = this.getUuid();
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < 4; ++i) {
            sb.append(this.getHexByte(uuid[i]));
        }
        sb.append('-');
        for (i = 4; i < 6; ++i) {
            sb.append(this.getHexByte(uuid[i]));
        }
        sb.append('-');
        for (i = 6; i < 8; ++i) {
            sb.append(this.getHexByte(uuid[i]));
        }
        sb.append('-');
        for (i = 8; i < 10; ++i) {
            sb.append(this.getHexByte(uuid[i]));
        }
        sb.append('-');
        for (i = 10; i < 16; ++i) {
            sb.append(this.getHexByte(uuid[i]));
        }
        return sb.toString();
    }

    private String getHexByte(byte c) {
        String byteStr = Integer.toHexString(c & 0xFF);
        if (byteStr.length() == 2) {
            return byteStr;
        }
        return "0" + byteStr;
    }

    private long getPtr() {
        return this.ptr;
    }

    private void setPtr(long ptr) {
        this.ptr = ptr;
    }

    private long getDriverPtr() {
        return this.driverPtr;
    }

    private void setDriverPtr(long driverPtr) {
        this.driverPtr = driverPtr;
    }

    private void setDriverDefinedPtr(long driverDefinedPtr) {
        this.driverDefinedPtr = driverDefinedPtr;
    }

    private long getDriverDefinedPtr() {
        return this.driverDefinedPtr;
    }

    public String getPath() {
        return this.path;
    }

    public int getProductId() {
        return this.productId;
    }

    public int getVendorId() {
        return this.vendorId;
    }

    public String getModel() {
        return this.model;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void writeImage(int x, int y, BufferedImage image) throws IOException {
        this.writeImage(x, y, image, 32);
    }

    public void writeImage(int x, int y, BufferedImage image, int targetDepth) throws IOException {
        int imageDepth;
        Display d = this.getDisplayInfo();
        int bitDepth = d.getColorDepth();
        int n = bitDepth = targetDepth < bitDepth ? targetDepth : bitDepth;
        if (x < 0 || x > d.getWidth() || y < 0 || y > d.getWidth()) {
            throw new IOException("Coordinates out of range: " + x + "," + y);
        }
        if (x + image.getWidth() > d.getWidth() || y + image.getHeight() > d.getHeight()) {
            throw new IOException("Image would draw off screen.");
        }
        switch (image.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                imageDepth = 24;
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                imageDepth = 4;
                break;
            }
            default: {
                imageDepth = 1;
            }
        }
        bitDepth = imageDepth < bitDepth ? imageDepth : bitDepth;
        switch (bitDepth) {
            case 24: {
                this.writeImageColor(x, y, image);
                break;
            }
            case 4: {
                this.writeImageGray(x, y, image);
                break;
            }
            default: {
                this.writeImageBlackWhite(x, y, image);
            }
        }
    }

    public void setResource(Resource resource) throws IOException {
        ResourceGraphic resourceG;
        BufferedImage image;
        if (resource instanceof ResourceGraphic && (image = (resourceG = (ResourceGraphic)resource).getGraphic()) != null) {
            Capabilities c = this.getCapabilities();
            BufferedImage imgConvert = c.getColorDepth() == 1 ? new BufferedImage(image.getWidth(), image.getHeight(), 12) : (c.getColorDepth() == 4 ? new BufferedImage(image.getWidth(), image.getHeight(), 12, this.colorModel4Bit) : new BufferedImage(image.getWidth(), image.getHeight(), 12));
            imgConvert.createGraphics().drawImage(image, 0, 0, Color.WHITE, null);
            resourceG.setGraphic(imgConvert);
        }
        this.setResourceImpl(resource);
    }

    private void writeImageColor(int x, int y, BufferedImage image) throws IOException {
        int TILE_SIZE = 26;
        byte[] buffer = new byte[2039];
        for (int iX = 0; iX < image.getWidth(); iX += 26) {
            for (int iY = 0; iY < image.getHeight(); iY += 26) {
                int width = iX + 26 <= image.getWidth() ? 26 : image.getWidth() - iX;
                int height = iY + 26 <= image.getHeight() ? 26 : image.getHeight() - iY;
                BufferedImage tile = image.getSubimage(iX, iY, width, height);
                this.packColorRaster(buffer, tile);
                this.writeDisplayChunk(new DisplayChunk(iX + x, iY + y, tile.getWidth(), tile.getHeight(), 24, buffer));
            }
        }
    }

    private void packColorRaster(byte[] buffer, BufferedImage tile) {
        int pos = 0;
        for (int x = 0; x < tile.getWidth(); ++x) {
            for (int y = 0; y < tile.getHeight(); ++y) {
                int color = tile.getRGB(x, y);
                buffer[pos++] = (byte)((color & 0xFF0000) >> 16);
                buffer[pos++] = (byte)((color & 0xFF00) >> 8);
                buffer[pos++] = (byte)(color & 0xFF);
            }
        }
    }

    private void writeImageGray(int x, int y, BufferedImage img) throws IOException {
        BufferedImage image;
        Object[] samples;
        if (img.getType() != 12 || img.getSampleModel().getSampleSize()[0] != 4) {
            samples = new byte[]{0, 16, 32, 48, 64, 80, 96, 112, -128, -112, -96, -80, -64, -48, -32, -16};
            BufferedImage tmp = new BufferedImage(img.getWidth(), img.getHeight(), 12, new IndexColorModel(4, 16, (byte[])samples, (byte[])samples, (byte[])samples));
            tmp.getGraphics().drawImage(img, 0, 0, null);
            image = tmp;
        } else {
            image = img;
        }
        samples = new int[image.getWidth() * image.getHeight()];
        image.getRaster().getPixels(0, 0, image.getWidth(), image.getHeight(), (int[])samples);
        int len = (int)Math.ceil((double)samples.length / 2.0);
        byte[] buffer = new byte[len];
        int i = 0;
        for (int iX = 0; iX < image.getWidth(); ++iX) {
            for (int iY = 0; iY < image.getHeight(); ++iY) {
                int rasterPos = iY * image.getWidth() + iX;
                int n = i / 2;
                buffer[n] = (byte)(buffer[n] | (i % 2 == 1 ? samples[rasterPos] << 4 : samples[rasterPos]));
                ++i;
            }
        }
        byte[] buf = new byte[2039];
        int chunkWidth = (int)Math.ceil(2039.0 / (double)image.getHeight());
        int chunks = (int)Math.ceil((double)image.getWidth() / (double)chunkWidth);
        int chunkSize = chunkWidth * image.getHeight() / 2;
        for (int chunk = 0; chunk < chunks; ++chunk) {
            int start = chunk * chunkSize;
            int end = start + chunkSize;
            if (end > buffer.length) {
                end = buffer.length;
            }
            System.arraycopy(buffer, start, buf, 0, end - start);
            int remaining = image.getWidth() - chunkWidth * chunk;
            int cWidth = remaining < chunkWidth ? remaining : chunkWidth;
            this.writeDisplayChunk(new DisplayChunk(x + chunkWidth * chunk, y, cWidth, image.getHeight(), 4, buf));
        }
    }

    private void writeImageBlackWhite(int x, int y, BufferedImage img) throws IOException {
        BufferedImage image;
        Object[] samples;
        if (img.getType() != 12 || img.getSampleModel().getSampleSize()[0] != 1) {
            samples = new byte[]{-1, 0};
            BufferedImage tmp = new BufferedImage(img.getWidth(), img.getHeight(), 12, new IndexColorModel(1, 2, (byte[])samples, (byte[])samples, (byte[])samples));
            tmp.getGraphics().drawImage(img, 0, 0, null);
            image = tmp;
        } else {
            image = img;
        }
        samples = new int[image.getWidth() * image.getHeight()];
        image.getRaster().getPixels(0, 0, image.getWidth(), image.getHeight(), (int[])samples);
        int len = (int)Math.ceil((double)samples.length / 8.0);
        byte[] buffer = new byte[len];
        int bytePos = 0;
        int bitPos = 0;
        for (int iX = 0; iX < image.getWidth(); ++iX) {
            for (int iY = 0; iY < image.getHeight(); ++iY) {
                int rasterPos = iY * image.getWidth() + iX;
                int n = bytePos++;
                buffer[n] = (byte)(buffer[n] | samples[rasterPos] << 7 - bitPos);
                if (++bitPos % 8 != 0) continue;
                bitPos = 0;
            }
        }
        this.writeDisplayChunk(new DisplayChunk(x, y, image.getWidth(), image.getHeight(), 1, buffer));
    }

    public void updateFirmwareFromMot(InputStream stream) throws IOException {
        this.updateFirmwareFromMot(stream, null);
    }

    public void updateFirmwareFromMot(InputStream stream, FirmwareListener callback) throws IOException {
        SRECFirmwarePackage pkg = new SRECFirmwarePackage();
        this.updateFirmwareFromPackage(pkg, stream, callback);
    }

    public void updateFirmwareFromFw(InputStream stream) throws IOException {
        this.updateFirmwareFromFw(stream, null);
    }

    public void updateFirmwareFromFw(InputStream stream, FirmwareListener callback) throws IOException {
        FWFirmwarePackage pkg = new FWFirmwarePackage();
        this.updateFirmwareFromPackage(pkg, stream, callback);
    }

    public native void simulatePenInput(int var1, int var2, int var3, boolean var4) throws IOException;

    private native byte[] getDisplayBuffer(int var1, int var2, int var3) throws IOException;

    public BufferedImage getDisplayContents() throws IOException {
        Display info = this.getDisplayInfo();
        BufferedImage image = new BufferedImage(info.getWidth(), info.getHeight(), 2);
        int x = 0;
        int y = 0;
        while (x < info.getWidth() && y < info.getHeight()) {
            byte[] buffer = this.getDisplayBuffer(x, y, 256);
            for (int i = 0; i < buffer.length; i += 4) {
                int color = (buffer[i] & 0xFF) << 24 | (buffer[i + 1] & 0xFF) << 16 | (buffer[i + 2] & 0xFF) << 8 | buffer[i + 3] & 0xFF;
                image.setRGB(x, y, color);
                if (++x < info.getWidth()) continue;
                x = 0;
                ++y;
            }
        }
        return image;
    }

    private native void setFeatureReport(byte[] var1) throws IOException;

    private native void getFeatureReport(byte[] var1) throws IOException;

    private native void setOutputReport(byte[] var1) throws IOException;

    public void updateFirmwareFromPackage(FirmwarePackage pkg, InputStream stream, FirmwareListener callback) throws IOException {
        FirmwarePage page;
        pkg.readStream(stream);
        boolean compatible = true;
        for (FirmwareRestriction r : pkg.getRestrictions()) {
            if (r.meetsRestriction(this)) continue;
            compatible = false;
        }
        if (!compatible) {
            throw new IOException("Firmware is not compatible with this device.");
        }
        int i = 0;
        while ((page = pkg.nextPage()) != null) {
            this.setFirmwarePage(page);
            if (callback != null) {
                callback.receiveFirmwareUpdateNotification((double)i / (double)pkg.getPageCount());
            }
            ++i;
        }
        this.setFirmwareComplete();
        if (callback != null) {
            callback.receiveFirmwareUpdateNotification(1.0);
            callback.receiveFirmwareUpdateComplete();
        }
    }
}

