/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript;

public class Capabilities {
    public static final int SUPPORTED_REPORTS_HID = 1;
    public static final int SUPPORTED_REPORTS_MOUSE = 2;
    public static final int SUPPORTED_REPORTS_PEN = 4;
    public static final int SUPPORTED_REPORTS_TOUCH = 8;
    public static final int SUPPORTED_REPORTS_KEYBOARD = 16;
    public static final int SUPPORTED_STREAMING = 1;
    public static final int SUPPORTED_BUFFERING = 2;
    public static final int SUPPORTED_COMPRESSION = 4;
    public static final int SUPPORTED_THROTTLING = 8;
    public static final int DISPLAY_TYPE_NONE = 0;
    public static final int DISPLAY_TYPE_240X64_1X5_BLACKWHITE = 1;
    public static final int DISPLAY_TYPE_240X64_1X5_GRAYSCALE = 2;
    @Deprecated
    public static final int SCRIPTEL_CARDREADER_NONE = 0;
    @Deprecated
    public static final int SCRIPTEL_CARDREADER_HID = 1;
    @Deprecated
    public static final int SCRIPTEL_CARDREADER_KEYBOARD_BASIC = 2;
    @Deprecated
    public static final int SCRIPTEL_CARDREADER_KEYBOARD_PREAMBLE = 3;
    @Deprecated
    public static final int SCRIPTEL_CARDREADER_INTERCHANGEABLE = 131;
    public static final int SCRIPTEL_MAG_CARDREADER_HID = 1;
    public static final int SCRIPTEL_MAG_CARDREADER_KEYBOARD = 2;
    public static final int SCRIPTEL_MAG_CARDREADER_CHANGEABLE = 128;
    private final int supportedReports;
    private final int coordinateModes;
    private final int displayId;
    private final int brightnessLevels;
    private final int contrastLevels;
    private final int colorDepth;
    private final int displayWidth;
    private final int displayHeight;
    private final int digitizerWidth;
    private final int digitizerHeight;
    private final int coordinateXMin;
    private final int coordinateXMax;
    private final int coordinateYMin;
    private final int coordinateYMax;
    private final int calibrationXMin;
    private final int calibrationXMax;
    private final int calibrationYMin;
    private final int calibrationYMax;
    private final int reserved4;
    private final int reserved5;
    private final int cardReader;
    private final int reserved6;
    private final int reserved7;
    private final boolean supportsScreensResources;
    private final int reserved9;
    private final int reserved10;
    private final int reserved11;
    private final int reserved12;
    private final int reserved13;
    private final int reserved14;

    private Capabilities(int supportedReports, int coordinateModes, int displayId, int brightnessLevels, int contrastLevels, int colorDepth, int displayWidth, int displayHeight, int digitizerWidth, int digitizerHeight, int coordinateXMin, int coordinateXMax, int coordinateYMin, int coordinateYMax, int calibrationXMin, int calibrationXMax, int calibrationYMin, int calibrationYMax, int reserved4, int reserved5, int cardReader, int reserved6, int reserved7, boolean supportsScreensResources, int reserved9, int reserved10, int reserved11, int reserved12, int reserved13, int reserved14) {
        this.supportedReports = supportedReports;
        this.coordinateModes = coordinateModes;
        this.displayId = displayId;
        this.brightnessLevels = brightnessLevels;
        this.contrastLevels = contrastLevels;
        this.colorDepth = colorDepth;
        this.displayWidth = displayWidth;
        this.displayHeight = displayHeight;
        this.digitizerWidth = digitizerWidth;
        this.digitizerHeight = digitizerHeight;
        this.coordinateXMin = coordinateXMin;
        this.coordinateXMax = coordinateXMax;
        this.coordinateYMin = coordinateYMin;
        this.coordinateYMax = coordinateYMax;
        this.calibrationXMin = calibrationXMin;
        this.calibrationXMax = calibrationXMax;
        this.calibrationYMin = calibrationYMin;
        this.calibrationYMax = calibrationYMax;
        this.reserved4 = reserved4;
        this.reserved5 = reserved5;
        this.cardReader = cardReader;
        this.reserved6 = reserved6;
        this.reserved7 = reserved7;
        this.supportsScreensResources = supportsScreensResources;
        this.reserved9 = reserved9;
        this.reserved10 = reserved10;
        this.reserved11 = reserved11;
        this.reserved12 = reserved12;
        this.reserved13 = reserved13;
        this.reserved14 = reserved14;
    }

    private String toHex(int v) {
        StringBuilder hex = new StringBuilder(Integer.toHexString(v));
        while (hex.length() < 4) {
            hex.insert(0, '0');
        }
        hex.insert(0, "0x");
        return hex.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Capabilities: \n");
        sb.append("   supportedReports: ").append(this.toHex(this.supportedReports)).append("\n");
        if ((this.supportedReports & 1) > 0) {
            sb.append("\tSUPPORTED_REPORTS_HID\n");
        }
        if ((this.supportedReports & 2) > 0) {
            sb.append("\tSUPPORTED_REPORTS_MOUSE\n");
        }
        if ((this.supportedReports & 4) > 0) {
            sb.append("\tSUPPORTED_REPORTS_PEN\n");
        }
        if ((this.supportedReports & 8) > 0) {
            sb.append("\tSUPPORTED_REPORTS_TOUCH\n");
        }
        if ((this.supportedReports & 0x10) > 0) {
            sb.append("\tSUPPORTED_REPORTS_KEYBOARD\n");
        }
        sb.append("   coordinateModes: ").append(this.toHex(this.coordinateModes)).append("\n");
        if ((this.coordinateModes & 1) > 0) {
            sb.append("\tSUPPORTED_STREAMING\n");
        }
        if ((this.coordinateModes & 2) > 0) {
            sb.append("\tSUPPORTED_BUFFERING\n");
        }
        if ((this.coordinateModes & 4) > 0) {
            sb.append("\tSUPPORTED_COMPRESSION\n");
        }
        if ((this.coordinateModes & 8) > 0) {
            sb.append("\tSUPPORTED_THROTTLING\n");
        }
        sb.append("          displayId: ");
        switch (this.displayId) {
            case 1: {
                sb.append("DISPLAY_TYPE_240X64_1X5_BLACKWHITE");
                break;
            }
            case 2: {
                sb.append("DISPLAY_TYPE_240X64_1X5_GRAYSCALE");
                break;
            }
            case 0: {
                sb.append("DISPLAY_TYPE_NONE");
                break;
            }
            default: {
                sb.append("UNKNOWN (").append(this.displayId).append(')');
            }
        }
        sb.append("\n");
        sb.append("        brightnessLevels: ").append(this.brightnessLevels).append("\n");
        sb.append("          contrastLevels: ").append(this.contrastLevels).append("\n");
        sb.append("              colorDepth: ").append(this.colorDepth).append("\n");
        sb.append("            displayWidth: ").append(this.displayWidth).append("\n");
        sb.append("           displayHeight: ").append(this.displayHeight).append("\n");
        sb.append("          digitizerWidth: ").append(this.digitizerWidth).append("\n");
        sb.append("         digitizerHeight: ").append(this.digitizerHeight).append("\n");
        sb.append("          coordinateXMin: ").append(this.coordinateXMin).append("\n");
        sb.append("          coordinateXMax: ").append(this.coordinateXMax).append("\n");
        sb.append("          coordinateYMin: ").append(this.coordinateYMin).append("\n");
        sb.append("          coordinateYMax: ").append(this.coordinateYMax).append("\n");
        sb.append("         calibrationXMin: ").append(this.calibrationXMin).append("\n");
        sb.append("         calibrationXMax: ").append(this.calibrationXMax).append("\n");
        sb.append("         calibrationYMin: ").append(this.calibrationYMin).append("\n");
        sb.append("         calibrationYMax: ").append(this.calibrationYMax).append("\n");
        sb.append("               reserved4: ").append(this.reserved4).append("\n");
        sb.append("               reserved5: ").append(this.reserved5).append("\n");
        sb.append("              cardReader: ");
        switch (this.cardReader) {
            case 0: {
                sb.append("SCRIPTEL_CARDREADER_NONE");
                break;
            }
            case 1: {
                sb.append("SCRIPTEL_CARDREADER_HID");
                break;
            }
            case 2: {
                sb.append("SCRIPTEL_CARDREADER_KEYBOARD_BASIC");
                break;
            }
            case 3: {
                sb.append("SCRIPTEL_CARDREADER_KEYBOARD_PREAMBLE");
                break;
            }
            case 131: {
                sb.append("SCRIPTEL_CARDREADER_INTERCHANGEABLE");
                break;
            }
            default: {
                sb.append("UNKNOWN");
            }
        }
        sb.append("\n");
        sb.append(" cardReader capabilities: ");
        if (this.cardReader == 0) {
            sb.append("NONE");
        } else {
            boolean valueAdded = false;
            if ((this.cardReader & 1) == 1) {
                valueAdded = true;
                sb.append("SCRIPTEL_MAG_CARDREADER_HID");
            }
            if ((this.cardReader & 2) == 2) {
                if (valueAdded) {
                    sb.append(", ");
                }
                valueAdded = true;
                sb.append("SCRIPTEL_MAG_CARDREADER_KEYBOARD, ");
            }
            if ((this.cardReader & 0x80) == 128) {
                if (valueAdded) {
                    sb.append(", ");
                }
                sb.append("SCRIPTEL_MAG_CARDREADER_CHANGEABLE");
            }
        }
        sb.append('\n');
        sb.append("               reserved6: ").append(this.reserved6).append("\n");
        sb.append("               reserved7: ").append(this.reserved7).append("\n");
        sb.append("supportsScreensResources: ").append(this.supportsScreensResources).append("\n");
        sb.append("               reserved9: ").append(this.reserved9).append("\n");
        sb.append("              reserved10: ").append(this.reserved10).append("\n");
        sb.append("              reserved11: ").append(this.reserved11).append("\n");
        sb.append("              reserved12: ").append(this.reserved12).append("\n");
        sb.append("              reserved13: ").append(this.reserved13).append("\n");
        sb.append("              reserved14: ").append(this.reserved14).append("\n");
        return sb.toString();
    }

    public int getSupportedReports() {
        return this.supportedReports;
    }

    public int getCoordinateModes() {
        return this.coordinateModes;
    }

    public int getDisplayId() {
        return this.displayId;
    }

    public int getBrightnessLevels() {
        return this.brightnessLevels;
    }

    public int getContrastLevels() {
        return this.contrastLevels;
    }

    public int getColorDepth() {
        return this.colorDepth;
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public int getDisplayHeight() {
        return this.displayHeight;
    }

    public int getDigitizerWidth() {
        return this.digitizerWidth;
    }

    public int getDigitizerHeight() {
        return this.digitizerHeight;
    }

    public int getCoordinateXMin() {
        return this.coordinateXMin;
    }

    public int getCoordinateXMax() {
        return this.coordinateXMax;
    }

    public int getCoordinateYMin() {
        return this.coordinateYMin;
    }

    public int getCoordinateYMax() {
        return this.coordinateYMax;
    }

    public int getCalibrationXMin() {
        return this.calibrationXMin;
    }

    public int getCalibrationXMax() {
        return this.calibrationXMax;
    }

    public int getCalibrationYMin() {
        return this.calibrationYMin;
    }

    public int getCalibrationYMax() {
        return this.calibrationYMax;
    }

    public int getReserved4() {
        return this.reserved4;
    }

    public int getReserved5() {
        return this.reserved5;
    }

    public int getCardReader() {
        return this.cardReader;
    }

    public int getReserved6() {
        return this.reserved6;
    }

    public int getReserved7() {
        return this.reserved7;
    }

    public boolean getSupportsScreensResources() {
        return this.supportsScreensResources;
    }

    public int getReserved9() {
        return this.reserved9;
    }

    public int getReserved10() {
        return this.reserved10;
    }

    public int getReserved11() {
        return this.reserved11;
    }

    public int getReserved12() {
        return this.reserved12;
    }

    public int getReserved13() {
        return this.reserved13;
    }

    public int getReserved14() {
        return this.reserved14;
    }

    public boolean isBufferingSupported() {
        return (this.coordinateModes & 2) != 0;
    }

    public boolean isStreamingSupported() {
        return (this.coordinateModes & 1) != 0;
    }

    public boolean isThrottlingSupported() {
        return (this.coordinateModes & 8) != 0;
    }

    public boolean isCompressionSupported() {
        return (this.coordinateModes & 4) != 0;
    }

    public boolean isKeyboardOutSupported() {
        return (this.supportedReports & 0x10) != 0;
    }
}

