/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.proscript;

public class CalibrationState {
    public static final int POINT_CENTER = 0;
    public static final int POINT_UPPER_LEFT = 2;
    public static final int POINT_LOWER_LEFT = 4;
    public static final int POINT_LOWER_RIGHT = 6;
    public static final int POINT_UPPER_RIGHT = 8;
    private final boolean calibrationMode;
    private final int point;

    private CalibrationState(boolean calibrationMode, int point) {
        this.calibrationMode = calibrationMode;
        this.point = point;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CalibrationState:\n");
        sb.append("  calibrationMode: ").append(this.isCalibrationMode()).append('\n');
        sb.append("            point: ").append(CalibrationState.getPointName(this.getPoint())).append(" (").append(this.getPoint()).append(")\n");
        return sb.toString();
    }

    public static String getPointName(int point) {
        switch (point) {
            case 0: {
                return "POINT_CENTER";
            }
            case 2: {
                return "POINT_UPPER_LEFT";
            }
            case 4: {
                return "POINT_LOWER_LEFT";
            }
            case 6: {
                return "POINT_LOWER_RIGHT";
            }
            case 8: {
                return "POINT_UPPER_RIGHT";
            }
        }
        return "Unknown";
    }

    public boolean isCalibrationMode() {
        return this.calibrationMode;
    }

    public int getPoint() {
        return this.point;
    }
}

