﻿Imports System.Drawing.Imaging
Imports System.Threading
Imports ProScript

Public Class Form1
    Implements IDeviceNotificationListener
    Implements IInputListener

    Public Property CurrentDevice As Device
    Private Property bitmap As Bitmap
    Private Property graphics As Graphics
    Private Property pen As Pen
    Private Property lastCoordinate As Coordinate
    Private Property readDeviceThreadRef As Thread
    Private Property range As CoordinateRange
    Private Property connected As Boolean = False
    Private Property clearOnNext As Boolean = False
    Public Sub ReceiveCoordinateEvent(c As Coordinate) Implements IInputListener.ReceiveCoordinateEvent
        Console.WriteLine("Coordinate: x=" & c.GetX() & ", y=" & c.GetY() & ", penDown=" & c.IsPenDown())

        If clearOnNext Then
            Clear()
            clearOnNext = False
        End If

        If Not lastCoordinate Is Nothing Then
            graphics.DrawLine(pen, AdjustScale(lastCoordinate), AdjustScale(c))
            Dim cd As MethodInvoker = AddressOf setbitmap
            Me.Invoke(cd)
        End If

        If c.IsPenDown() Then
            'If so, save the last coordinate.
            lastCoordinate = c
        Else
            'If Not, throw away the last coordinate to start a New stroke.
            lastCoordinate = Nothing
        End If
    End Sub

    Private Sub setbitmap()
        signature.Image = bitmap
    End Sub

    Private Function AdjustScale(c As Coordinate) As PointF
        'Take both the X And Y coordinates And subtract the minimum range And divide by
        'the maximum range. This gives a number between 0 And 1 representing the percentage
        'of the width/height of the screen the pen Is currently located in.
        Dim x As Double = (c.GetX() - range.GetXMin()) / CDbl(range.GetXMax())
        Dim y As Double = (c.GetY() - range.GetYMin()) / CDbl(range.GetYMax())

        'This will adjust the X And Y coordinates to fit in the designated box.
        x *= signature.Width
        y *= signature.Height

        'Create a New point.
        Return New PointF(x, y)
    End Function

    Private Sub ReadDeviceThread()
        While Not CurrentDevice Is Nothing AndAlso CurrentDevice.IsOpen()
            Try
                CurrentDevice.Read()
            Catch ex As STException
                Dim cd As MethodInvoker = AddressOf CloseDevice
                Me.Invoke(cd)
            End Try
        End While
    End Sub

    Public Sub ReceiveDebugCoordinateEvent(c As DebugCoordinate) Implements IInputListener.ReceiveDebugCoordinateEvent
        'We aren't interested in this type of event.
    End Sub

    Public Sub ReceiveMagneticStripEvent(c As MagneticCardSwipe) Implements IInputListener.ReceiveMagneticStripEvent
        'We aren't interested in this type of event.
    End Sub

    Public Sub ReceiveADCScanValues(c As ADCScanValues) Implements IInputListener.ReceiveADCScanValues
        'We aren't interested in this type of event.
    End Sub

    Public Sub ReceiveADCChannelValues(c As ADCChannelValues) Implements IInputListener.ReceiveADCChannelValues
        'We aren't interested in this type of event.
    End Sub

    Public Sub ReceiveButtonEvent(c As ButtonEvent) Implements IInputListener.ReceiveButtonEvent
        'Test to see if the button Is pressed (it could also be a button down, button move Or button up).
        If TypeOf c Is ButtonPress Then
            If c.GetRegion() = 3 Then
                'Ok Button, accept, but clear on next input.
                clearOnNext = True
            ElseIf (c.GetRegion() = 4) Then
                'Cancel Button, clear immediately.
                Clear()
            End If
        End If
    End Sub

    Public Sub ReceiveDeviceAttachedNotification(path As String, device As Device) Implements IDeviceNotificationListener.ReceiveDeviceAttachedNotification
        Dim cd As MethodInvoker = AddressOf ReloadDeviceList
        Me.Invoke(cd)
    End Sub

    Public Sub ReceiveDeviceDetachedNotification(path As String, device As Device) Implements IDeviceNotificationListener.ReceiveDeviceDetachedNotification
        'Reload the device list on the main thread.
        Dim cd As MethodInvoker = AddressOf ReloadDeviceList
        Me.Invoke(cd)
    End Sub

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        Dim devices As List(Of Device)
        DeviceManager.RegisterDeviceListener(Me)

        'List the devices currently attached to the system.
        devices = DeviceManager.GetAttachedDevices

        Dim device As Device
        Me.bitmap = New Bitmap(signature.Width, signature.Height)
        graphics = Graphics.FromImage(bitmap)
        pen = New Pen(Color.Black, 2)

        ReloadDeviceList()

        If devices.Count > 0 Then
            'Get a reference to the first device.
            device = devices.Item(0)
            Console.WriteLine("Opening " & device.GetModel() & " (Sign / Swipe now)")
            'Sets the device property of our event handling class.
            CurrentDevice = device
            OpenDevice()
        End If
    End Sub

    Private Sub connectButton_Click(sender As Object, e As EventArgs) Handles connectButton.Click
        If connected Then
            CloseDevice()
        Else
            OpenDevice()
        End If
    End Sub

    Private Sub CloseDevice()
        If Not CurrentDevice Is Nothing AndAlso CurrentDevice.IsOpen() Then
            Try
                CurrentDevice.Close()
            Catch ex As STException
                'This can occur if the device has been removed from the system.
            End Try
        End If
        status.Text = "Disconnected"
        CurrentDevice = Nothing
        status.ForeColor = Color.Red
        connectButton.Text = "Connect"
        connected = False
    End Sub

    Private Sub OpenDevice()
        If Not connected And Not CurrentDevice Is Nothing Then
            CurrentDevice.RegisterInputListener(Me)
            CurrentDevice.Open()

            range = CurrentDevice.GetCoordinateRange()

            readDeviceThreadRef = New Thread(AddressOf ReadDeviceThread)
            readDeviceThreadRef.IsBackground = True
            readDeviceThreadRef.Start()

            status.Text = "Connected"
            status.ForeColor = Color.Green
            connectButton.Text = "Disconnect"
            connected = True
        End If
    End Sub

    Public Sub Clear()
        Dim brush As Brush = New SolidBrush(signature.BackColor)
        graphics.FillRectangle(brush, 0, 0, signature.Width, signature.Height)
        signature.Image = bitmap

        If connected And Not CurrentDevice Is Nothing Then
            CurrentDevice.ClearScreen()
        End If
    End Sub

    Private Sub clearButton_Click(sender As Object, e As EventArgs) Handles clearButton.Click
        Clear()
    End Sub

    Private Sub saveButton_Click(sender As Object, e As EventArgs) Handles saveButton.Click

        Dim dialog As SaveFileDialog = New SaveFileDialog()
        dialog.Filter = "PNG Files|*.png"
        If dialog.ShowDialog() = DialogResult.OK Then
            signature.Image.Save(dialog.FileName, ImageFormat.Png)
        End If
    End Sub

    Private Sub ReloadDeviceList()
        deviceSelect.Items.Clear()
        Dim devices As List(Of Device)
        devices = DeviceManager.GetAttachedDevices()
        For Each item As Device In devices
            Dim wrapper As DeviceComboWrapper = New DeviceComboWrapper(item)
            deviceSelect.Items.Add(wrapper)
            If Not CurrentDevice Is Nothing AndAlso CurrentDevice.GetPath() = item.GetPath() Then
                'This one should be selected.
                deviceSelect.SelectedItem = wrapper
            End If
        Next

        If deviceSelect.SelectedIndex < 0 And deviceSelect.Items.Count > 0 Then
            deviceSelect.SelectedIndex = 0
        End If
    End Sub

    Private Sub deviceSelect_SelectedIndexChanged(sender As Object, e As EventArgs) Handles deviceSelect.SelectedIndexChanged
        'If any device Is open close it.
        CloseDevice()

        Dim wrapper As DeviceComboWrapper = deviceSelect.SelectedItem
        If Not wrapper Is Nothing Then
            CurrentDevice = wrapper.Device
        End If
    End Sub
End Class
