﻿' <copyright file="VBConsoleExample.vb" company="Scriptel Corporation">
'      Copyright 2015 - Scriptel Corporation
' </copyright>
Imports ProScript

''' <summary>
''' This module shows a very simple exmaple of how to open and read from a
''' ScripTouch device.
''' </summary>
Module VBConsoleExample
    ''' <summary>
    ''' Main subroutine for this program.
    ''' </summary>
    ''' <remarks></remarks>
    Sub Main()
        'A reference to our event handling class.
        Dim example As VBConsoleExample = New VBConsoleExample
        'The list of devices from the library.
        Dim devices As List(Of Device)
        'A reference to our device.
        Dim device As Device

        'Regster our event handling class as interested in hotplug events.
        DeviceManager.RegisterDeviceListener(example)

        'List the devices currently attached to the system.
        devices = DeviceManager.GetAttachedDevices

        'Print out the devices we've found.
        Console.WriteLine("Found " & devices.Count & " device(s): ")
        For Each d As Device In devices
            Console.WriteLine("   " & d.GetModel())
        Next

        'Test to make sure we have at least one device.
        If devices.Count > 0 Then
            'Get a reference to the first device.
            device = devices.Item(0)
            Console.WriteLine("Opening " & device.GetModel() & " (Sign / Swipe now)")
            'Sets the device property of our event handling class.
            example.Device = device
            'Register our event handling class as interested in device events.
            device.RegisterInputListener(example)
            'Open the device.
            device.Open()

            'While the device is open
            While device.IsOpen
                'Read from the device.
                Try
                    device.Read()
                Catch ex As STException
                    Console.WriteLine(ex.Message)
                End Try
            End While
        Else
            Console.WriteLine("No devices found, exiting.")
        End If
    End Sub

    ''' <summary>
    ''' This class is an event handler for ProScript library events.
    ''' </summary>
    Class VBConsoleExample
        Implements IDeviceNotificationListener
        Implements IInputListener

        ''' <summary>
        ''' Reference to the open device.
        ''' </summary>
        ''' <value>Reference to the open device.</value>
        ''' <returns>Reference to the open device.</returns>
        Public Property Device As Device

        ''' <summary>
        ''' This method gets called when a new device is plugged into the system.
        ''' </summary>
        ''' <param name="path">Path of the device.</param>
        ''' <param name="device">Reference to the device.</param>
        Public Sub ReceiveDeviceAttachedNotification(path As String, device As Device) Implements IDeviceNotificationListener.ReceiveDeviceAttachedNotification
            Console.WriteLine("Device added to the system: " & path)
        End Sub

        ''' <summary>
        ''' This method gets called when a device is removed from the system.
        ''' </summary>
        ''' <param name="path">Path of the device.</param>
        ''' <param name="device">Reference to the device.</param>
        ''' <remarks></remarks>
        Public Sub ReceiveDeviceDetachedNotification(path As String, device As Device) Implements IDeviceNotificationListener.ReceiveDeviceDetachedNotification
            Console.WriteLine("Device removed from the system: " & path)
        End Sub

        ''' <summary>
        ''' This method gets called when a button on the device is pressed.
        ''' </summary>
        ''' <param name="c">Button event from the device.</param>
        Public Sub ReceiveButtonEvent(c As ButtonEvent) Implements IInputListener.ReceiveButtonEvent
            Console.WriteLine("ButtonEvent: type=" & c.GetType().ToString() & ", x=" & c.GetX() & ", y=" & c.GetY() & ", region=" & c.GetRegion())

            If TypeOf c Is ButtonPress And c.GetRegion() = 3 Then
                Device.Close()
            End If
        End Sub

        ''' <summary>
        ''' This method gets called when a coordinate event is generated on the device.
        ''' </summary>
        ''' <param name="c">Coordinate event.</param>
        Public Sub ReceiveCoordinateEvent(c As Coordinate) Implements IInputListener.ReceiveCoordinateEvent
            Console.WriteLine("Coordinate: x=" & c.GetX() & ", y=" & c.GetY() & ", penDown=" & c.IsPenDown())
        End Sub

        ''' <summary>
        ''' This method gets called when a magnetic card swipe event is generated on the device.
        ''' </summary>
        ''' <param name="c">Magnetic card swipe event.</param>
        Public Sub ReceiveMagneticStripEvent(c As MagneticCardSwipe) Implements IInputListener.ReceiveMagneticStripEvent
            Console.WriteLine(c)
        End Sub

        ''' <summary>
        ''' This method gets called when a diagnostic event is generated.
        ''' </summary>
        ''' <param name="c">Diagnostic event</param>
        Public Sub ReceiveDebugCoordinateEvent(c As DebugCoordinate) Implements IInputListener.ReceiveDebugCoordinateEvent
            'We generally don't care about these events.
        End Sub

        ''' <summary>
        ''' This method gets called when a diagnostic event is generated.
        ''' </summary>
        ''' <param name="c">Diagnostic event</param>
        Public Sub ReceiveADCChannelValues(c As ADCChannelValues) Implements IInputListener.ReceiveADCChannelValues
            'We generally don't care about these events.
        End Sub

        ''' <summary>
        ''' This method gets called when a diagnostic event is generated.
        ''' </summary>
        ''' <param name="c">Diagnostic event</param>
        Public Sub ReceiveADCScanValues(c As ADCScanValues) Implements IInputListener.ReceiveADCScanValues
            'We generally don't care about these events.
        End Sub
    End Class
End Module
