﻿// <copyright file="DeviceComboWrapper.cs" company="Scriptel Corporation">
//      Copyright 2015 - Scriptel Corporation
// </copyright>
namespace FormExample
{
    using ProScript;

    /// <summary>
    /// This class is used to wrap a device for a combo box so we can
    /// specify how ToString() is implemented. We could also pass along
    /// other data through this class.
    /// </summary>
    class DeviceComboWrapper
    {
        /// <summary>
        /// Device property.
        /// </summary>
        public Device Device
        {
            get;
            set;
        }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="d">Device to store in Device.</param>
        public DeviceComboWrapper(Device d)
        {
            this.Device = d;
        }

        /// <summary>
        /// Returns the model name of the device.
        /// </summary>
        /// <returns>Model name of the device.</returns>
        public override string ToString()
        {
            return Device.GetModel();
        }
    }
}
